/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection.oracle;

import org.mule.extension.db.internal.domain.connection.BaseDbConnectionParameters;
import org.mule.extension.db.internal.domain.connection.DataSourceConfig;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

public class OracleConnectionParameters
extends BaseDbConnectionParameters
implements DataSourceConfig {
    private static final String DRIVER_CLASS_NAME = "oracle.jdbc.driver.OracleDriver";
    private static final String JDBC_URL_PREFIX = "jdbc:oracle:thin:@";
    @Parameter
    @Placement(order=1)
    private String host;
    @Parameter
    @Optional(defaultValue="1521")
    @Placement(order=2)
    private Integer port;
    @Parameter
    @Optional
    @Placement(order=3)
    private String user;
    @Parameter
    @Optional
    @Placement(order=4)
    @Password
    private String password;
    @Parameter
    @Optional
    @Placement(order=5)
    private String instance;

    @Override
    public String getUrl() {
        return this.generateUrl();
    }

    @Override
    public String getDriverClassName() {
        return DRIVER_CLASS_NAME;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    private String generateUrl() {
        StringBuilder buf = new StringBuilder(JDBC_URL_PREFIX);
        buf.append(this.host);
        buf.append(":");
        buf.append(this.port);
        if (this.instance != null) {
            buf.append(":");
            buf.append(this.instance);
        }
        return buf.toString();
    }
}

