/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection.mysql;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

final class MySqlDbUtils {
    MySqlDbUtils() {
    }

    static String getEffectiveUrl(String urlPrefix, String host, Integer port, String database, Map<String, String> connectionProperties) {
        String url = MySqlDbUtils.buildUrlFromAttributes(urlPrefix, host, port, database);
        return MySqlDbUtils.addProperties(url, connectionProperties);
    }

    static String getEffectiveUrl(String url, Map<String, String> connectionProperties) {
        return MySqlDbUtils.addProperties(url, connectionProperties);
    }

    private static String buildUrlFromAttributes(String urlPrefix, String host, Integer port, String database) {
        StringBuilder buf = new StringBuilder(128);
        buf.append(urlPrefix);
        buf.append(host);
        if (port != null && port > 0) {
            buf.append(":");
            buf.append(port);
        }
        buf.append("/");
        if (database != null) {
            buf.append(database);
        }
        String url = buf.toString();
        return url;
    }

    private static String addProperties(String url, Map<String, String> connectionProperties) {
        if (connectionProperties != null && !connectionProperties.isEmpty()) {
            StringBuilder effectiveUrl = new StringBuilder(url);
            String queryParams = MySqlDbUtils.buildQueryParams(connectionProperties);
            if (MySqlDbUtils.getUri(url).getQuery() == null) {
                effectiveUrl.append("?");
            } else {
                effectiveUrl.append("&");
            }
            effectiveUrl.append(queryParams);
            return effectiveUrl.toString();
        }
        return url;
    }

    private static String buildQueryParams(Map<String, String> connectionProperties) {
        StringBuilder params = new StringBuilder(128);
        if (connectionProperties != null) {
            for (Map.Entry<String, String> entry : connectionProperties.entrySet()) {
                if (params.length() > 0) {
                    params.append('&');
                }
                params.append(entry.getKey()).append('=').append(entry.getValue());
            }
        }
        return params.toString();
    }

    private static URI getUri(String url) {
        try {
            return new URI(url.substring(5));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to parse database config URL", e);
        }
    }
}

