/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection.mysql;

import java.util.HashMap;
import java.util.Map;
import org.mule.extension.db.internal.domain.connection.BaseDbConnectionParameters;
import org.mule.extension.db.internal.domain.connection.DataSourceConfig;
import org.mule.extension.db.internal.domain.connection.mysql.MySqlDbUtils;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

public final class MySqlConnectionParameters
extends BaseDbConnectionParameters
implements DataSourceConfig {
    private static final String MYSQL_DRIVER_CLASS = "com.mysql.jdbc.Driver";
    private static final String MY_SQL_PREFIX = "jdbc:mysql://";
    @Parameter
    @Placement(order=1)
    private String host;
    @Parameter
    @Placement(order=2)
    private Integer port;
    @Parameter
    @Optional
    @Placement(order=3)
    private String user;
    @Parameter
    @Optional
    @Placement(order=4)
    @Password
    private String password;
    @Parameter
    @Optional
    @Placement(order=5)
    private String database;
    @Parameter
    @Optional
    @Placement(tab="Advanced")
    private Map<String, String> connectionProperties = new HashMap<String, String>();

    @Override
    public String getUrl() {
        return MySqlDbUtils.getEffectiveUrl(MY_SQL_PREFIX, this.host, this.port, this.database, this.connectionProperties);
    }

    @Override
    public String getDriverClassName() {
        return MYSQL_DRIVER_CLASS;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getUser() {
        return this.user;
    }
}

