/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.mule.extension.db.api.exception.connection.ConnectionCreationException;
import org.mule.extension.db.internal.domain.type.DbType;
import org.mule.extension.db.internal.domain.type.MappedStructResolvedDbType;
import org.mule.runtime.api.connection.ConnectionException;

class JdbcConnectionFactory {
    JdbcConnectionFactory() {
    }

    public Connection createConnection(DataSource dataSource, List<DbType> customDataTypes) throws ConnectionException {
        Connection connection;
        try {
            connection = dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new ConnectionCreationException("Could not obtain connection from data source", e);
        }
        if (connection == null) {
            throw new ConnectionCreationException("Unable to create connection to the provided dataSource: " + dataSource);
        }
        Map<String, Class<?>> typeMapping = this.createTypeMapping(customDataTypes);
        if (typeMapping != null && !typeMapping.isEmpty()) {
            try {
                connection.setTypeMap(typeMapping);
            }
            catch (SQLException e) {
                throw new ConnectionCreationException("Could not set custom data types on connection", e);
            }
        }
        return connection;
    }

    private Map<String, Class<?>> createTypeMapping(List<DbType> customDataTypes) {
        HashMap typeMapping = new HashMap();
        customDataTypes.stream().filter(dbType -> dbType instanceof MappedStructResolvedDbType).forEach(dbType -> {
            MappedStructResolvedDbType structDbType = (MappedStructResolvedDbType)dbType;
            if (structDbType.getMappedClass() != null) {
                typeMapping.put(structDbType.getName(), structDbType.getMappedClass());
            }
        });
        return typeMapping;
    }
}

