/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection;

import com.google.common.collect.ImmutableList;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.extension.db.api.exception.connection.ConnectionClosingException;
import org.mule.extension.db.internal.domain.connection.DbConnection;
import org.mule.extension.db.internal.domain.type.DbType;
import org.mule.extension.db.internal.result.resultset.ResultSetHandler;
import org.mule.extension.db.internal.result.statement.GenericStatementResultIteratorFactory;
import org.mule.extension.db.internal.result.statement.StatementResultIteratorFactory;

public class DefaultDbConnection
implements DbConnection {
    private final Connection jdbcConnection;
    private AtomicInteger streamsCount = new AtomicInteger(0);
    private final List<DbType> customDataTypes;

    public DefaultDbConnection(Connection jdbcConnection, List<DbType> customDataTypes) {
        this.jdbcConnection = jdbcConnection;
        this.customDataTypes = customDataTypes;
    }

    @Override
    public StatementResultIteratorFactory getStatementResultIteratorFactory(ResultSetHandler resultSetHandler) {
        return new GenericStatementResultIteratorFactory(resultSetHandler);
    }

    @Override
    public List<DbType> getVendorDataTypes() {
        return ImmutableList.of();
    }

    @Override
    public Connection getJdbcConnection() {
        return this.jdbcConnection;
    }

    @Override
    public List<DbType> getCustomDataTypes() {
        return this.customDataTypes;
    }

    public void begin() throws Exception {
        if (this.jdbcConnection.getAutoCommit()) {
            this.jdbcConnection.setAutoCommit(false);
        }
    }

    public void commit() throws SQLException {
        this.jdbcConnection.commit();
        this.abortStreaming();
    }

    public void rollback() throws SQLException {
        this.jdbcConnection.rollback();
        this.abortStreaming();
    }

    @Override
    public void release() {
        if (this.isStreaming()) {
            return;
        }
        try {
            this.jdbcConnection.close();
        }
        catch (SQLException e) {
            throw new ConnectionClosingException(e);
        }
    }

    @Override
    public void beginStreaming() {
        this.streamsCount.incrementAndGet();
    }

    @Override
    public boolean isStreaming() {
        return this.streamsCount.get() > 0;
    }

    @Override
    public void endStreaming() {
        this.streamsCount.decrementAndGet();
    }

    private void abortStreaming() {
        this.streamsCount.set(0);
    }
}

