/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import org.apache.commons.lang.StringUtils;
import org.mule.extension.db.api.config.DbPoolingProfile;
import org.mule.extension.db.api.exception.connection.ConnectionClosingException;
import org.mule.extension.db.api.exception.connection.ConnectionCommitException;
import org.mule.extension.db.api.exception.connection.ConnectionCreationException;
import org.mule.extension.db.api.param.CustomDataType;
import org.mule.extension.db.internal.domain.connection.DataSourceConfig;
import org.mule.extension.db.internal.domain.connection.DataSourceFactory;
import org.mule.extension.db.internal.domain.connection.DbConnection;
import org.mule.extension.db.internal.domain.connection.DefaultDbConnection;
import org.mule.extension.db.internal.domain.connection.JdbcConnectionFactory;
import org.mule.extension.db.internal.domain.type.ArrayResolvedDbType;
import org.mule.extension.db.internal.domain.type.ClobResolvedDataType;
import org.mule.extension.db.internal.domain.type.DbType;
import org.mule.extension.db.internal.domain.type.MappedStructResolvedDbType;
import org.mule.extension.db.internal.domain.type.ResolvedDbType;
import org.mule.extension.db.internal.domain.type.StructuredDbType;
import org.mule.extension.db.internal.domain.xa.XADbConnection;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.util.collection.ImmutableListCollector;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.ConfigName;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbConnectionProvider
implements ConnectionProvider<DbConnection>,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbConnectionProvider.class);
    @ConfigName
    private String configName;
    @Inject
    private MuleContext muleContext;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced")
    private DbPoolingProfile poolingProfile;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private List<CustomDataType> customDataTypes = Collections.emptyList();
    private DataSourceFactory dataSourceFactory;
    private List<DbType> resolvedCustomTypes = Collections.emptyList();
    private JdbcConnectionFactory jdbcConnectionFactory = new JdbcConnectionFactory();
    private DataSource dataSource;

    public final DbConnection connect() throws ConnectionException {
        try {
            Connection jdbcConnection = this.jdbcConnectionFactory.createConnection(this.dataSource, this.resolvedCustomTypes);
            DbConnection connection = this.createDbConnection(jdbcConnection);
            if (jdbcConnection instanceof XAConnection) {
                connection = new XADbConnection(connection, (XAConnection)((Object)jdbcConnection));
            }
            return connection;
        }
        catch (Exception e) {
            throw new ConnectionCreationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disconnect(DbConnection connection) {
        Connection jdbcConnection = connection.getJdbcConnection();
        try {
            if (jdbcConnection.isClosed()) {
                return;
            }
        }
        catch (SQLException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error checking for closed connection while trying to disconnect", (Throwable)e);
            }
            return;
        }
        RuntimeException exception = null;
        try {
            if (!jdbcConnection.getAutoCommit()) {
                jdbcConnection.commit();
            }
        }
        catch (SQLException e) {
            exception = new ConnectionCommitException(e);
        }
        finally {
            block18: {
                try {
                    connection.release();
                }
                catch (Exception e) {
                    if (exception != null) break block18;
                    exception = new ConnectionClosingException(e);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public ConnectionValidationResult validate(DbConnection connection) {
        return ConnectionValidationResult.success();
    }

    public final void initialise() throws InitialisationException {
        this.dataSourceFactory = this.createDataSourceFactory();
        try {
            this.dataSource = this.obtainDataSource();
        }
        catch (SQLException e) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)("Could not create DataSource for DB config " + this.configName)), (Throwable)e, (Initialisable)this);
        }
        this.resolvedCustomTypes = this.resolveCustomTypes();
    }

    public final void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.dataSourceFactory, (Logger)LOGGER);
    }

    public abstract Optional<DataSource> getDataSource();

    public abstract Optional<DataSourceConfig> getDataSourceConfig();

    protected DbConnection createDbConnection(Connection connection) throws Exception {
        return new DefaultDbConnection(connection, this.resolvedCustomTypes);
    }

    private DataSource obtainDataSource() throws SQLException {
        DataSource dataSource;
        Optional<DataSource> optionalDataSource = this.getDataSource();
        if (optionalDataSource.isPresent()) {
            dataSource = optionalDataSource.get();
        } else {
            DataSourceConfig dataSourceConfig = this.getDataSourceConfig().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not create DataSource for DB config, no DataSource or DataSourceConfig has been provided " + this.configName))));
            dataSource = this.createDataSource(dataSourceConfig);
        }
        return this.dataSourceFactory.decorateDataSource(dataSource, this.poolingProfile);
    }

    private DataSource createDataSource(DataSourceConfig dataSourceConfig) throws SQLException {
        return this.dataSourceFactory.create(dataSourceConfig, this.poolingProfile);
    }

    protected List<DbType> resolveCustomTypes() {
        return (List)this.customDataTypes.stream().map(type -> {
            String name = type.getTypeName();
            int id = type.getId();
            if (id == 2003) {
                return new ArrayResolvedDbType(id, name);
            }
            if (id == 2002) {
                String className = type.getClassName();
                if (!StringUtils.isEmpty((String)className)) {
                    Class<?> mappedClass;
                    try {
                        mappedClass = Class.forName(className);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("Cannot find mapped class: " + className);
                    }
                    return new MappedStructResolvedDbType(id, name, mappedClass);
                }
                return new StructuredDbType(id, name);
            }
            if (id == 2005) {
                return new ClobResolvedDataType(id, name);
            }
            return new ResolvedDbType(id, name);
        }).collect(new ImmutableListCollector());
    }

    private DataSourceFactory createDataSourceFactory() {
        return new DataSourceFactory(this.configName, this.muleContext);
    }

    public DataSource getConfiguredDataSource() {
        return this.dataSource;
    }
}

