/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.connection;

import com.mchange.v2.c3p0.DataSources;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Set;
import javax.sql.DataSource;
import org.enhydra.jdbc.standard.StandardDataSource;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.mule.extension.db.api.config.DbPoolingProfile;
import org.mule.extension.db.internal.domain.connection.DataSourceConfig;
import org.mule.extension.db.internal.domain.xa.CompositeDataSourceDecorator;
import org.mule.runtime.api.config.DatabasePoolingProfile;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.tx.DataSourceDecorator;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.util.concurrent.ConcurrentHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceFactory
implements Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceFactory.class);
    private final String name;
    private final Set<DataSource> pooledDataSources = new ConcurrentHashSet();
    private final Set<Disposable> disposableDataSources = new ConcurrentHashSet();
    private final CompositeDataSourceDecorator dataSourceDecorator;

    public DataSourceFactory(String name, MuleContext muleContext) {
        this.name = name;
        this.dataSourceDecorator = new CompositeDataSourceDecorator(muleContext.getRegistry().lookupObjects(DataSourceDecorator.class));
    }

    public DataSource create(DataSourceConfig dataSourceConfig, DbPoolingProfile poolingProfile) throws SQLException {
        DataSource dataSource = poolingProfile == null ? this.createSingleDataSource(dataSourceConfig) : this.createPooledDataSource(dataSourceConfig, poolingProfile);
        if (dataSourceConfig.isUseXaTransactions()) {
            dataSource = this.decorateDataSource(dataSource, poolingProfile);
        }
        if (poolingProfile != null && !dataSourceConfig.isUseXaTransactions()) {
            this.pooledDataSources.add(dataSource);
        } else if (dataSource instanceof Disposable) {
            this.disposableDataSources.add((Disposable)dataSource);
        }
        return dataSource;
    }

    public DataSource decorateDataSource(DataSource dataSource, DatabasePoolingProfile poolingProfile) {
        return this.dataSourceDecorator.decorate(dataSource, this.name, poolingProfile);
    }

    protected DataSource createSingleDataSource(DataSourceConfig dataSourceConfig) throws SQLException {
        StandardXADataSource dataSource = dataSourceConfig.isUseXaTransactions() ? new StandardXADataSource() : new StandardDataSource();
        dataSource.setDriverName(dataSourceConfig.getDriverClassName());
        dataSource.setPassword(dataSourceConfig.getPassword());
        dataSource.setTransactionIsolation(dataSourceConfig.getTransactionIsolation().getCode());
        dataSource.setUrl(dataSourceConfig.getUrl());
        dataSource.setUser(dataSourceConfig.getUser());
        return dataSource;
    }

    protected DataSource createPooledDataSource(DataSourceConfig dataSourceConfig, DbPoolingProfile poolingProfile) throws SQLException {
        if (dataSourceConfig.isUseXaTransactions()) {
            return this.createSingleDataSource(dataSourceConfig);
        }
        return this.createPooledStandardDataSource(this.createSingleDataSource(dataSourceConfig), poolingProfile);
    }

    protected DataSource createPooledStandardDataSource(DataSource dataSource, DatabasePoolingProfile poolingProfile) throws SQLException {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("maxPoolSize", poolingProfile.getMaxPoolSize());
        config.put("minPoolSize", poolingProfile.getMinPoolSize());
        config.put("initialPoolSize", poolingProfile.getMinPoolSize());
        config.put("checkoutTimeout", new Long(poolingProfile.getMaxWaitUnit().toMillis(poolingProfile.getMaxWait())).intValue());
        config.put("acquireIncrement", poolingProfile.getAcquireIncrement());
        config.put("maxStatements", 0);
        config.put("testConnectionOnCheckout", "true");
        config.put("maxStatementsPerConnection", poolingProfile.getPreparedStatementCacheSize());
        return DataSources.pooledDataSource((DataSource)dataSource, config);
    }

    public void dispose() {
        for (DataSource pooledDataSource : this.pooledDataSources) {
            try {
                DataSources.destroy((DataSource)pooledDataSource);
            }
            catch (SQLException e) {
                LOGGER.warn("Unable to properly release pooled data source", (Throwable)e);
            }
        }
        for (Disposable disposableDataSource : this.disposableDataSources) {
            try {
                disposableDataSource.dispose();
            }
            catch (Exception e) {
                LOGGER.warn("Unable to properly dispose data source", (Throwable)e);
            }
        }
    }
}

