/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal.domain.autogeneratedkey;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.mule.extension.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.extension.db.internal.domain.connection.DbConnection;
import org.mule.extension.db.internal.domain.query.QueryTemplate;

public class ColumnNameAutoGeneratedKeyStrategy
implements AutoGeneratedKeyStrategy {
    private final String[] columnNames;

    public ColumnNameAutoGeneratedKeyStrategy(String[] columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public boolean returnsAutoGeneratedKeys() {
        return true;
    }

    @Override
    public PreparedStatement prepareStatement(DbConnection connection, QueryTemplate queryTemplate) throws SQLException {
        return connection.getJdbcConnection().prepareStatement(queryTemplate.getSqlText(), this.columnNames);
    }

    @Override
    public boolean execute(Statement statement, QueryTemplate queryTemplate) throws SQLException {
        if (statement instanceof PreparedStatement) {
            return ((PreparedStatement)statement).execute();
        }
        return statement.execute(queryTemplate.getSqlText(), this.columnNames);
    }

    @Override
    public int executeUpdate(Statement statement, QueryTemplate queryTemplate) throws SQLException {
        if (statement instanceof PreparedStatement) {
            return ((PreparedStatement)statement).executeUpdate();
        }
        return statement.executeUpdate(queryTemplate.getSqlText(), this.columnNames);
    }
}

