/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.internal;

import java.sql.ResultSet;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.mule.extension.db.internal.domain.connection.DbConnection;
import org.mule.extension.db.internal.result.statement.AbstractStreamingResultSetCloser;

public class StatementStreamingResultSetCloser
extends AbstractStreamingResultSetCloser {
    private final ConcurrentHashMap<DbConnection, Set<ResultSet>> connectionResultSets = new ConcurrentHashMap();
    private final ConcurrentHashMap<DbConnection, Object> connectionLocks = new ConcurrentHashMap();

    public StatementStreamingResultSetCloser() {
    }

    public StatementStreamingResultSetCloser(boolean autoCloseConnection) {
        super(autoCloseConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeResultSets(DbConnection connection) {
        Object connectionLock;
        Object object = connectionLock = this.getConnectionLock(connection);
        synchronized (object) {
            this.checkValidConnectionLock(connection, connectionLock);
            Set<ResultSet> resultSets = this.connectionResultSets.get(connection);
            if (resultSets != null) {
                for (ResultSet resultSet : resultSets) {
                    super.close(connection, resultSet);
                }
            }
            this.releaseResources(connection, connectionLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(DbConnection connection, ResultSet resultSet) {
        Object connectionLock;
        Object object = connectionLock = this.getTrackedConnectionLock(connection);
        synchronized (object) {
            this.checkValidConnectionLock(connection, connectionLock);
            Set<ResultSet> resultSets = this.getConnectionResultSets(connection, resultSet);
            try {
                super.close(connection, resultSet);
            }
            finally {
                if (CollectionUtils.isEmpty(resultSets)) {
                    this.releaseResources(connection, connectionLock);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackResultSet(DbConnection connection, ResultSet resultSet) {
        Object connectionLock;
        Object object = connectionLock = this.getConnectionLock(connection);
        synchronized (object) {
            Set<ResultSet> resultSets = this.connectionResultSets.get(connection);
            if (resultSets == null) {
                resultSets = new HashSet<ResultSet>();
                this.connectionResultSets.put(connection, resultSets);
            }
            resultSets.add(resultSet);
        }
    }

    protected Object getTrackedConnectionLock(DbConnection connection) {
        Object connectionLock = this.connectionLocks.get(connection);
        if (connectionLock == null) {
            throw new IllegalStateException("Attempting to close resultSet from non tracked connection");
        }
        return connectionLock;
    }

    protected void releaseResources(DbConnection connection, Object connectionLock) {
        this.connectionResultSets.remove(connection);
        this.connectionLocks.remove(connectionLock);
        connection.release();
    }

    protected Set<ResultSet> getConnectionResultSets(DbConnection connection, ResultSet resultSet) {
        Set<ResultSet> resultSets = this.connectionResultSets.get(connection);
        if (resultSets != null && !resultSets.remove(resultSet)) {
            throw new IllegalStateException("Attempting to close non tracked resultSet");
        }
        return resultSets;
    }

    protected void checkValidConnectionLock(DbConnection connection, Object connectionLock) {
        if (connectionLock != this.connectionLocks.get(connection)) {
            throw new ConcurrentModificationException("Connection lock modified in another thread");
        }
    }

    protected Object getConnectionLock(DbConnection connection) {
        Object oldConnectionLock;
        Object connectionLock = this.connectionLocks.get(connection);
        if (connectionLock == null && (oldConnectionLock = this.connectionLocks.putIfAbsent(connection, connectionLock = new Object())) != null) {
            connectionLock = oldConnectionLock;
        }
        return connectionLock;
    }
}

