/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.api.param;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.mule.extension.db.api.param.ParameterType;
import org.mule.extension.db.api.param.QuerySettings;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Text;

public abstract class StatementDefinition<T extends StatementDefinition>
extends QuerySettings {
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Text
    @DisplayName(value="SQL Query Text")
    @Placement(order=1)
    @MetadataKeyId
    protected String sql;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Placement(tab="Advanced")
    private List<ParameterType> parameterTypes = new LinkedList<ParameterType>();

    public abstract T getTemplate();

    public T resolveFromTemplate() {
        T template = this.getTemplate();
        if (template == null) {
            return (T)this;
        }
        template = ((StatementDefinition)template).resolveFromTemplate();
        T resolvedDefinition = this.copy();
        if (StringUtils.isBlank((String)((StatementDefinition)resolvedDefinition).getSql())) {
            ((StatementDefinition)resolvedDefinition).setSql(((StatementDefinition)template).getSql());
        }
        return resolvedDefinition;
    }

    protected T copy() {
        StatementDefinition copy;
        try {
            copy = (StatementDefinition)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not create instance of " + this.getClass().getName())), (Throwable)e);
        }
        copy.sql = this.sql;
        copy.parameterTypes = new LinkedList<ParameterType>(this.parameterTypes);
        copy.copyInto(this);
        return (T)copy;
    }

    public Optional<ParameterType> getParameterType(String paramName) {
        return this.parameterTypes.stream().filter(p -> p.getKey().equals(paramName)).findFirst();
    }

    public List<ParameterType> getParameterTypes() {
        return this.parameterTypes;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }
}

