/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.db.api.param;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.extension.db.internal.domain.type.BlobDbType;
import org.mule.extension.db.internal.domain.type.ClobResolvedDataType;
import org.mule.extension.db.internal.domain.type.DbType;
import org.mule.extension.db.internal.domain.type.ResolvedDbType;
import org.mule.extension.db.internal.domain.type.UnknownDbType;

public enum JdbcType {
    BIT(new ResolvedDbType(-7, "BIT")),
    TINYINT(new ResolvedDbType(-6, "TINYINT")),
    SMALLINT(new ResolvedDbType(5, "SMALLINT")),
    INTEGER(new ResolvedDbType(4, "INTEGER")),
    BIGINT(new ResolvedDbType(-5, "BIGINT")),
    FLOAT(new ResolvedDbType(6, "FLOAT")),
    REAL(new ResolvedDbType(7, "REAL")),
    DOUBLE(new ResolvedDbType(8, "DOUBLE")),
    NUMERIC(new ResolvedDbType(2, "NUMERIC")),
    DECIMAL(new ResolvedDbType(3, "DECIMAL")),
    CHAR(new ResolvedDbType(1, "CHAR")),
    VARCHAR(new ResolvedDbType(12, "VARCHAR")),
    LONGVARCHAR(new ResolvedDbType(-1, "LONGVARCHAR")),
    DATE(new ResolvedDbType(91, "DATE")),
    TIME(new ResolvedDbType(92, "TIME")),
    TIMESTAMP(new ResolvedDbType(93, "TIMESTAMP")),
    BINARY(new ResolvedDbType(-2, "BINARY")),
    VARBINARY(new ResolvedDbType(-3, "VARBINARY")),
    LONGVARBINARY(new ResolvedDbType(-4, "LONGVARBINARY")),
    NULL(new ResolvedDbType(0, "NULL")),
    OTHER(new ResolvedDbType(1111, "OTHER")),
    JAVA_OBJECT(new ResolvedDbType(2000, "JAVA_OBJECT")),
    DISTINCT(new ResolvedDbType(2001, "DISTINCT")),
    STRUCT(new ResolvedDbType(2002, "STRUCT")),
    ARRAY(new ResolvedDbType(2003, "ARRAY")),
    BLOB(new BlobDbType(2004, "BLOB")),
    CLOB(new ClobResolvedDataType(2005, "CLOB")),
    REF(new ResolvedDbType(2006, "REF")),
    DATALINK(new ResolvedDbType(70, "DATALINK")),
    BOOLEAN(new ResolvedDbType(16, "BOOLEAN")),
    ROWID(new ResolvedDbType(-8, "ROWID")),
    NCHAR(new ResolvedDbType(-15, "NCHAR")),
    NVARCHAR(new ResolvedDbType(-9, "NVARCHAR")),
    LONGNVARCHAR(new ResolvedDbType(-16, "LONGNVARCHAR")),
    NCLOB(new ResolvedDbType(2011, "NCLOB")),
    SQLXML(new ResolvedDbType(2009, "SQLXML")),
    UNKNOWN(UnknownDbType.getInstance());

    private final DbType dbType;

    private JdbcType(DbType dbType) {
        this.dbType = dbType;
    }

    public static List<DbType> getAllTypes() {
        return Arrays.stream(JdbcType.values()).map(JdbcType::getDbType).collect(Collectors.toList());
    }

    public DbType getDbType() {
        return this.dbType;
    }
}

