/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.connection.DefaultDbConnectionReleaser;
import org.mule.module.db.internal.domain.connection.type.resolver.TypeResolver;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.resolver.param.ParamTypeResolver;
import org.mule.module.db.internal.resolver.param.ParamTypeResolverFactory;
import org.mule.module.db.internal.result.resultset.ResultSetHandler;
import org.mule.module.db.internal.result.statement.GenericStatementResultIteratorFactory;
import org.mule.module.db.internal.result.statement.StatementResultIteratorFactory;

public abstract class AbstractDbConnection
implements DbConnection {
    private final TransactionalAction transactionalAction;
    private final DefaultDbConnectionReleaser connectionReleaseListener;
    private final ParamTypeResolverFactory paramTypeResolverFactory;
    protected final Connection delegate;

    public AbstractDbConnection(Connection delegate, TransactionalAction transactionalAction, DefaultDbConnectionReleaser connectionReleaseListener, ParamTypeResolverFactory paramTypeResolverFactory) {
        this.delegate = delegate;
        this.transactionalAction = transactionalAction;
        this.connectionReleaseListener = connectionReleaseListener;
        this.paramTypeResolverFactory = paramTypeResolverFactory;
    }

    @Override
    public StatementResultIteratorFactory getStatementResultIteratorFactory(ResultSetHandler resultSetHandler) {
        return new GenericStatementResultIteratorFactory(resultSetHandler);
    }

    @Override
    public Map<Integer, DbType> getParamTypes(QueryTemplate queryTemplate) throws SQLException {
        ParamTypeResolver paramTypeResolver = this.paramTypeResolverFactory.create(queryTemplate);
        return paramTypeResolver.getParameterTypes(this, queryTemplate);
    }

    @Override
    public TransactionalAction getTransactionalAction() {
        return this.transactionalAction;
    }

    @Override
    public void release() {
        this.connectionReleaseListener.release(this);
    }

    protected void resolveLobs(String typeName, Object[] attributes, TypeResolver typeResolver) throws SQLException {
    }
}

