/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.domain.param;

import org.mule.config.spring.parsers.AbstractMuleBeanDefinitionParser;
import org.mule.config.spring.parsers.generic.AutoIdUtils;
import org.mule.module.db.internal.domain.query.QueryParamValue;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class InputParamValueBeanDefinitionParser
extends AbstractMuleBeanDefinitionParser {
    public static final String DEFAULT_VALUE_ATTRIBUTE = "defaultValue";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String NAME_ATTRIBUTE = "name";

    public InputParamValueBeanDefinitionParser() {
        this.addAlias(DEFAULT_VALUE_ATTRIBUTE, VALUE_ATTRIBUTE);
    }

    protected Class<?> getBeanClass(Element element) {
        return QueryParamValue.class;
    }

    protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        builder.setScope("singleton");
        builder.addConstructorArgValue((Object)this.getName(element));
        builder.addConstructorArgValue((Object)this.getValue(element));
    }

    private String getValue(Element element) {
        String value = element.hasAttribute(DEFAULT_VALUE_ATTRIBUTE) ? element.getAttribute(DEFAULT_VALUE_ATTRIBUTE) : element.getAttribute(VALUE_ATTRIBUTE);
        return value;
    }

    private String getName(Element element) {
        return element.getAttribute(NAME_ATTRIBUTE);
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext context) throws BeanDefinitionStoreException {
        return this.getBeanName(element);
    }

    public String getBeanName(Element element) {
        return AutoIdUtils.uniqueValue((String)("paramValue." + element.getAttribute(NAME_ATTRIBUTE)));
    }

    protected void checkElementNameUnique(Element element) {
    }

    protected boolean isSingleton() {
        return true;
    }
}

