/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.processor;

import java.util.Iterator;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.module.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.autogeneratedkey.NoAutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.executor.BulkQueryExecutorFactory;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.processor.AbstractDbMessageProcessor;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.module.db.internal.resolver.query.QueryResolver;
import org.mule.util.StringUtils;

public abstract class AbstractBulkUpdateMessageProcessor
extends AbstractDbMessageProcessor {
    protected final QueryResolver queryResolver;
    protected final BulkQueryExecutorFactory bulkUpdateExecutorFactory;
    protected final List<QueryType> validQueryTypes;
    protected AutoGeneratedKeyStrategy autoGeneratedKeyStrategy;
    protected String source;

    public AbstractBulkUpdateMessageProcessor(DbConfigResolver dbConfigResolver, TransactionalAction transactionalAction, List<QueryType> validQueryTypes, QueryResolver queryResolver, BulkQueryExecutorFactory bulkUpdateExecutorFactory) {
        super(dbConfigResolver, transactionalAction);
        this.validQueryTypes = validQueryTypes;
        this.queryResolver = queryResolver;
        this.autoGeneratedKeyStrategy = new NoAutoGeneratedKeyStrategy();
        this.bulkUpdateExecutorFactory = bulkUpdateExecutorFactory;
    }

    protected Iterator<Object> getIterator(MuleEvent muleEvent) {
        Object bulkData = StringUtils.isEmpty((String)this.source) ? muleEvent.getMessage().getPayload() : this.muleContext.getExpressionManager().evaluate(this.source, muleEvent);
        return this.getIterator(bulkData);
    }

    private Iterator<Object> getIterator(Object bulkData) {
        if (bulkData instanceof Iterable) {
            return ((Iterable)bulkData).iterator();
        }
        if (bulkData instanceof Iterator) {
            return (Iterator)bulkData;
        }
        throw new IllegalArgumentException(String.format("Bulk mode operations require Iterable/Iterator as input. Got %s instead", bulkData != null ? bulkData.getClass().getCanonicalName() : "null"));
    }

    @Override
    protected List<QueryType> getValidQueryTypes() {
        return this.validQueryTypes;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    public void setAutoGeneratedKeyStrategy(AutoGeneratedKeyStrategy autoGeneratedKeyStrategy) {
        this.autoGeneratedKeyStrategy = autoGeneratedKeyStrategy;
    }
}

