/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.processor;

import org.mule.module.db.internal.config.domain.query.BulkQueryResolverFactoryBean;
import org.mule.module.db.internal.config.processor.AbstractAdvancedDbProcessorDefinitionParser;
import org.mule.module.db.internal.domain.executor.BulkUpdateExecutorFactory;
import org.mule.module.db.internal.metadata.BulkExecuteMetadataProvider;
import org.mule.module.db.internal.parser.SimpleQueryTemplateParser;
import org.mule.module.db.internal.processor.BulkExecuteMessageProcessor;
import org.mule.module.db.internal.resolver.query.FileBulkQueryResolver;
import org.mule.module.db.internal.util.DefaultFileReader;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class BulkExecuteProcessorBeanDefinitionParser
extends AbstractAdvancedDbProcessorDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        return BulkExecuteMessageProcessor.class;
    }

    @Override
    protected Object getMetadataProvider() {
        BeanDefinitionBuilder metadataProviderBuilder = BeanDefinitionBuilder.genericBeanDefinition(BulkExecuteMetadataProvider.class);
        return metadataProviderBuilder.getBeanDefinition();
    }

    @Override
    protected void doParseElement(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        this.parseConfig(element, builder);
        this.parseBulkQuery(element, builder);
        this.parseSourceExpression(element, builder);
        this.parseTargetExpression(element, builder);
        this.parseExecutorFactory(element, builder);
        this.parseTransactionalAction(element, builder);
        this.parseMetadataProvider(element, builder);
        this.configureStatementResultSetCloser(builder);
    }

    private void parseBulkQuery(Element element, BeanDefinitionBuilder builder) {
        BeanDefinitionBuilder bulkQueryResolver;
        String file = element.getAttribute("file");
        if (StringUtils.isEmpty((String)file)) {
            bulkQueryResolver = BeanDefinitionBuilder.genericBeanDefinition(BulkQueryResolverFactoryBean.class);
            bulkQueryResolver.addConstructorArgValue((Object)element.getTextContent());
        } else {
            bulkQueryResolver = BeanDefinitionBuilder.genericBeanDefinition(FileBulkQueryResolver.class);
            bulkQueryResolver.addConstructorArgValue((Object)file);
            bulkQueryResolver.addConstructorArgValue((Object)new SimpleQueryTemplateParser());
            bulkQueryResolver.addConstructorArgValue((Object)new DefaultFileReader());
        }
        builder.addConstructorArgValue((Object)bulkQueryResolver.getBeanDefinition());
    }

    @Override
    protected Object createExecutorFactory(Element element) {
        BeanDefinitionBuilder executorFactoryBean = BeanDefinitionBuilder.genericBeanDefinition(BulkUpdateExecutorFactory.class);
        executorFactoryBean.addConstructorArgValue(this.parseStatementFactory(element));
        return executorFactoryBean.getBeanDefinition();
    }
}

