/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.processor;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.debug.FieldDebugInfo;
import org.mule.api.debug.FieldDebugInfoFactory;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.executor.BulkExecutor;
import org.mule.module.db.internal.domain.executor.BulkQueryExecutorFactory;
import org.mule.module.db.internal.domain.query.BulkQuery;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.processor.AbstractDbMessageProcessor;
import org.mule.module.db.internal.processor.DbDebugInfoUtils;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.module.db.internal.resolver.query.BulkQueryResolver;
import org.mule.module.db.internal.resolver.query.QueryResolutionException;

public class BulkExecuteMessageProcessor
extends AbstractDbMessageProcessor {
    private final BulkQueryResolver bulkQueryResolver;
    private final BulkQueryExecutorFactory bulkUpdateExecutorFactory;
    private final List<QueryType> validQueryTypes;

    public BulkExecuteMessageProcessor(DbConfigResolver dbConfigResolver, BulkQueryResolver bulkQueryResolver, BulkQueryExecutorFactory bulkUpdateExecutorFactory, TransactionalAction transactionalAction) {
        super(dbConfigResolver, transactionalAction);
        this.bulkQueryResolver = bulkQueryResolver;
        this.bulkUpdateExecutorFactory = bulkUpdateExecutorFactory;
        this.validQueryTypes = new ArrayList<QueryType>();
        this.validQueryTypes.add(QueryType.UPDATE);
        this.validQueryTypes.add(QueryType.INSERT);
        this.validQueryTypes.add(QueryType.DELETE);
        this.validQueryTypes.add(QueryType.DDL);
    }

    private void validateQueryTemplates(List<QueryTemplate> queryTemplates) {
        for (QueryTemplate queryTemplate : queryTemplates) {
            this.validateQueryType(queryTemplate);
        }
    }

    @Override
    protected Object executeQuery(DbConnection connection, MuleEvent muleEvent) throws SQLException {
        MuleEvent eventToUse = this.resolveSource(muleEvent);
        BulkQuery bulkQuery = this.bulkQueryResolver.resolve(eventToUse);
        this.validateQueryTemplates(bulkQuery.getQueryTemplates());
        BulkExecutor bulkUpdateExecutor = this.bulkUpdateExecutorFactory.create();
        return bulkUpdateExecutor.execute(connection, bulkQuery);
    }

    @Override
    protected List<QueryType> getValidQueryTypes() {
        return this.validQueryTypes;
    }

    @Override
    protected List<FieldDebugInfo<?>> getMessageProcessorDebugInfo(DbConnection connection, MuleEvent muleEvent) {
        BulkQuery bulkQuery;
        MuleEvent eventToUse = this.resolveSource(muleEvent);
        ArrayList fields = new ArrayList();
        try {
            bulkQuery = this.bulkQueryResolver.resolve(eventToUse);
        }
        catch (QueryResolutionException e) {
            fields.add((FieldDebugInfo<?>)FieldDebugInfoFactory.createFieldDebugInfo((String)"Queries", List.class, (Exception)e));
            return fields;
        }
        try {
            this.validateQueryTemplates(bulkQuery.getQueryTemplates());
        }
        catch (IllegalArgumentException e) {
            fields.add((FieldDebugInfo<?>)FieldDebugInfoFactory.createFieldDebugInfo((String)"Queries", List.class, (Exception)e));
            return fields;
        }
        ArrayList<FieldDebugInfo> queries = new ArrayList<FieldDebugInfo>();
        int queryIndex = 1;
        for (QueryTemplate queryTemplate : bulkQuery.getQueryTemplates()) {
            FieldDebugInfo fieldDebugInfo = DbDebugInfoUtils.createQueryFieldDebugInfo("Query" + queryIndex++, queryTemplate);
            queries.add(fieldDebugInfo);
        }
        fields.add((FieldDebugInfo<?>)FieldDebugInfoFactory.createFieldDebugInfo((String)"Queries", List.class, queries));
        return fields;
    }
}

