/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.database;

import com.mchange.v2.c3p0.DataSources;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.enhydra.jdbc.standard.StandardDataSource;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.module.db.internal.domain.connection.DbPoolingProfile;
import org.mule.module.db.internal.domain.connection.TransactionalDbConnectionFactory;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.domain.transaction.TransactionCoordinationDbTransactionManager;
import org.mule.module.db.internal.domain.type.DbTypeManager;
import org.mule.module.db.internal.domain.xa.CompositeDataSourceDecorator;

public class GenericDbConfig
implements DbConfig,
Initialisable {
    private DataSource dataSource;
    private final String name;
    private final TransactionalDbConnectionFactory dbConnectionFactory;
    private final DbTypeManager dbTypeManager;
    private final CompositeDataSourceDecorator databaseDecorator = new CompositeDataSourceDecorator();
    private DbPoolingProfile poolingProfile;
    private boolean useXaTransactions;
    private String username;
    private String password;
    private int connectionTimeout;
    private int transactionIsolation;
    private String driverClassName;
    private MuleContext muleContext;
    private String url;

    public GenericDbConfig(DataSource dataSource, String name, DbTypeManager dbTypeManager) {
        this.dataSource = dataSource;
        this.name = name;
        this.dbTypeManager = dbTypeManager;
        this.dbConnectionFactory = this.doCreateConnectionFactory();
    }

    protected TransactionalDbConnectionFactory doCreateConnectionFactory() {
        return new TransactionalDbConnectionFactory(this, new TransactionCoordinationDbTransactionManager(), this.dbTypeManager);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public TransactionalDbConnectionFactory getConnectionFactory() {
        return this.dbConnectionFactory;
    }

    public DbTypeManager getDbTypeManager() {
        return this.dbTypeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult test() {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            DefaultTestResult defaultTestResult = new DefaultTestResult(Result.Status.SUCCESS);
            return defaultTestResult;
        }
        catch (SQLException e) {
            DefaultTestResult defaultTestResult = new DefaultTestResult(Result.Status.FAILURE, e.getMessage());
            return defaultTestResult;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public Result<List<MetaDataKey>> getMetaDataKeys() {
        ArrayList keys = new ArrayList();
        return new DefaultResult(keys, Result.Status.SUCCESS, "Successfully obtained metadata");
    }

    public Result<MetaData> getMetaData(MetaDataKey metaDataKey) {
        return new DefaultResult(null, Result.Status.SUCCESS, "No metadata obtained");
    }

    public void initialise() throws InitialisationException {
        this.databaseDecorator.init(this.muleContext);
        DataSource instanceDataSource = this.dataSource;
        if (instanceDataSource == null) {
            try {
                this.dataSource = this.createDataSource();
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
        this.dataSource = this.decorateDataSourceIfRequired(this.dataSource);
    }

    protected DataSource createDataSource() throws Exception {
        if (this.poolingProfile == null) {
            DataSource singleDataSource = this.createSingleDataSource();
            return singleDataSource;
        }
        return this.createPooledDataSource();
    }

    private DataSource createSingleDataSource() throws SQLException {
        StandardXADataSource dataSource = this.useXaTransactions ? new StandardXADataSource() : new StandardDataSource();
        dataSource.setDriverName(this.driverClassName);
        if (this.connectionTimeout >= 0) {
            dataSource.setLoginTimeout(this.connectionTimeout);
        }
        dataSource.setPassword(this.password);
        dataSource.setTransactionIsolation(this.transactionIsolation);
        dataSource.setUrl(this.url);
        dataSource.setUser(this.username);
        return dataSource;
    }

    private DataSource createPooledDataSource() throws PropertyVetoException, SQLException {
        if (this.useXaTransactions) {
            return this.createPooledXaDataSource();
        }
        return this.createPooledStandardDataSource();
    }

    private DataSource createPooledStandardDataSource() throws PropertyVetoException, SQLException {
        HashMap<String, Integer> config = new HashMap<String, Integer>();
        config.put("maxPoolSize", this.poolingProfile.getMaxPoolSize());
        config.put("minPoolSize", this.poolingProfile.getMinPoolSize());
        config.put("initialPoolSize", this.poolingProfile.getMinPoolSize());
        config.put("checkoutTimeout", this.poolingProfile.getMaxWaitMillis());
        config.put("acquireIncrement", this.poolingProfile.getAcquireIncrement());
        config.put("maxStatements", 0);
        config.put("maxStatementsPerConnection", this.poolingProfile.getPreparedStatementCacheSize());
        return DataSources.pooledDataSource((DataSource)this.createSingleDataSource(), config);
    }

    private DataSource createPooledXaDataSource() throws SQLException {
        DataSource dataSource = this.createSingleDataSource();
        return this.decorateDataSourceIfRequired(dataSource);
    }

    private DataSource decorateDataSourceIfRequired(DataSource dataSource) {
        return this.databaseDecorator.decorate(dataSource, this.getName(), this.poolingProfile, this.muleContext);
    }

    public void setPoolingProfile(DbPoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }

    public void setUseXaTransactions(boolean useXaTransactions) {
        this.useXaTransactions = useXaTransactions;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTransactionIsolation(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }
}

