/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.domain.database;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.module.db.internal.domain.connection.DbPoolingProfile;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.domain.database.GenericDbConfig;
import org.mule.module.db.internal.domain.type.CompositeDbTypeManager;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.domain.type.DbTypeManager;
import org.mule.module.db.internal.domain.type.JdbcTypes;
import org.mule.module.db.internal.domain.type.MetadataDbTypeManager;
import org.mule.module.db.internal.domain.type.StaticDbTypeManager;
import org.mule.util.Preconditions;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class DbConfigFactoryBean
extends AbstractFactoryBean<DbConfig>
implements MuleContextAware,
Initialisable {
    private String name;
    private String url;
    private String driverClassName;
    private int connectionTimeout;
    private String password;
    private String user;
    private int transactionIsolation = -1;
    private DataSource dataSource;
    private MuleContext muleContext;
    private boolean useXaTransactions;
    private DbPoolingProfile poolingProfile;
    private GenericDbConfig dbConfig;
    private Map<String, String> connectionProperties;
    private List<DbType> customDataTypes;

    public Class<?> getObjectType() {
        return GenericDbConfig.class;
    }

    protected DbConfig createInstance() throws Exception {
        this.validate();
        DbTypeManager dbTypeManager = this.doCreateTypeManager();
        this.dbConfig = this.doCreateDbConfig(this.dataSource, dbTypeManager);
        this.dbConfig.setPoolingProfile(this.poolingProfile);
        this.dbConfig.setUseXaTransactions(this.useXaTransactions);
        this.dbConfig.setUrl(this.getEffectiveUrl());
        this.dbConfig.setConnectionTimeout(this.connectionTimeout);
        this.dbConfig.setUsername(this.user);
        this.dbConfig.setPassword(this.password);
        this.dbConfig.setTransactionIsolation(this.transactionIsolation);
        this.dbConfig.setDriverClassName(this.driverClassName);
        this.dbConfig.setMuleContext(this.muleContext);
        return this.dbConfig;
    }

    protected DbTypeManager doCreateTypeManager() {
        List<DbType> vendorDataTypes;
        ArrayList<DbTypeManager> typeManagers = new ArrayList<DbTypeManager>();
        typeManagers.add(new MetadataDbTypeManager());
        if (this.customDataTypes.size() > 0) {
            typeManagers.add(new StaticDbTypeManager(this.customDataTypes));
        }
        if ((vendorDataTypes = this.getVendorDataTypes()).size() > 0) {
            typeManagers.add(new StaticDbTypeManager(vendorDataTypes));
        }
        typeManagers.add(new StaticDbTypeManager(JdbcTypes.types));
        return new CompositeDbTypeManager(typeManagers);
    }

    protected List<DbType> getVendorDataTypes() {
        return Collections.EMPTY_LIST;
    }

    protected GenericDbConfig doCreateDbConfig(DataSource datasource, DbTypeManager dbTypeManager) {
        return new GenericDbConfig(datasource, this.name, dbTypeManager);
    }

    protected void validate() {
        if (this.dataSource != null) {
            Preconditions.checkState((boolean)this.connectionProperties.isEmpty(), (String)"connection-properties cannot be specified when a DataSource was provided");
        }
    }

    protected String getEffectiveUrl() {
        return this.url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTransactionIsolation(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    public void setconnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public Map<String, String> getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setConnectionProperties(Map<String, String> connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setUseXaTransactions(boolean useXaTransactions) {
        this.useXaTransactions = useXaTransactions;
    }

    public void setPoolingProfile(DbPoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }

    public void initialise() throws InitialisationException {
        this.dbConfig.initialise();
    }

    public List<DbType> getCustomDataTypes() {
        return this.customDataTypes;
    }

    public void setCustomDataTypes(List<DbType> customDataTypes) {
        this.customDataTypes = customDataTypes;
    }
}

