/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.config;

import org.mule.config.spring.handlers.AbstractMuleNamespaceHandler;
import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.processors.CheckExclusiveAttributeAndText;
import org.mule.config.spring.parsers.processors.CheckExclusiveAttributes;
import org.mule.config.spring.parsers.processors.CheckRequiredAttributes;
import org.mule.module.db.internal.config.domain.connection.PoolingProfileBeanDefinitionParser;
import org.mule.module.db.internal.config.domain.database.DbConfigDefinitionParser;
import org.mule.module.db.internal.config.domain.database.DbConfigFactoryBean;
import org.mule.module.db.internal.config.domain.database.DerbyConfigFactoryBean;
import org.mule.module.db.internal.config.domain.database.MySqlConfigFactoryBean;
import org.mule.module.db.internal.config.domain.database.OracleConfigFactoryBean;
import org.mule.module.db.internal.config.domain.param.InOutParamDefinitionDefinitionParser;
import org.mule.module.db.internal.config.domain.param.InputParamValueBeanDefinitionParser;
import org.mule.module.db.internal.config.domain.param.OutputParamDefinitionDefinitionParser;
import org.mule.module.db.internal.config.domain.query.QueryTemplateBeanDefinitionParser;
import org.mule.module.db.internal.config.processor.BulkExecuteProcessorBeanDefinitionParser;
import org.mule.module.db.internal.config.processor.DeleteProcessorBeanDefinitionParser;
import org.mule.module.db.internal.config.processor.ExecuteDdlProcessorBeanDefinitionParser;
import org.mule.module.db.internal.config.processor.InsertProcessorBeanDefinitionParser;
import org.mule.module.db.internal.config.processor.SelectProcessorDefinitionParser;
import org.mule.module.db.internal.config.processor.StoredProcedureProcessorBeanDefinitionParser;
import org.mule.module.db.internal.config.processor.UpdateProcessorBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class DbNamespaceHandler
extends NamespaceHandlerSupport {
    public void init() {
        this.registerBeanDefinitionParser("select", (BeanDefinitionParser)new SelectProcessorDefinitionParser());
        this.registerBeanDefinitionParser("update", new UpdateProcessorBeanDefinitionParser());
        this.registerBeanDefinitionParser("delete", new DeleteProcessorBeanDefinitionParser());
        this.registerBeanDefinitionParser("insert", new InsertProcessorBeanDefinitionParser());
        this.registerBeanDefinitionParser("execute-ddl", (BeanDefinitionParser)new ExecuteDdlProcessorBeanDefinitionParser());
        this.registerBeanDefinitionParser("stored-procedure", (BeanDefinitionParser)new StoredProcedureProcessorBeanDefinitionParser());
        BulkExecuteProcessorBeanDefinitionParser bulkExecuteProcessorBeanDefinitionParser = new BulkExecuteProcessorBeanDefinitionParser();
        bulkExecuteProcessorBeanDefinitionParser.registerPreProcessor((PreProcessor)new CheckExclusiveAttributeAndText("file"));
        this.registerBeanDefinitionParser("bulk-execute", (BeanDefinitionParser)bulkExecuteProcessorBeanDefinitionParser);
        this.registerBeanDefinitionParser("in-param", (BeanDefinitionParser)new InputParamValueBeanDefinitionParser());
        this.registerBeanDefinitionParser("out-param", (BeanDefinitionParser)new OutputParamDefinitionDefinitionParser());
        this.registerBeanDefinitionParser("inout-param", (BeanDefinitionParser)new InOutParamDefinitionDefinitionParser());
        this.registerBeanDefinitionParser("template-query", (BeanDefinitionParser)new QueryTemplateBeanDefinitionParser());
        this.registerBeanDefinitionParser("template-query-ref", (BeanDefinitionParser)new QueryTemplateBeanDefinitionParser());
        this.registerConfigDefinitionParsers();
        this.registerBeanDefinitionParser("pooling-profile", (BeanDefinitionParser)new PoolingProfileBeanDefinitionParser());
    }

    private void registerConfigDefinitionParsers() {
        this.registerBeanDefinitionParser("generic-config", (BeanDefinitionParser)new DbConfigDefinitionParser(DbConfigFactoryBean.class, new CheckExclusiveAttributes((String[][])new String[][]{{"driver", "url", "connectionTimeout", "transactionIsolation", "useXaTransactions"}, {"dataSource-ref"}})));
        this.registerBeanDefinitionParser("derby-config", (BeanDefinitionParser)new DbConfigDefinitionParser(DerbyConfigFactoryBean.class, new CheckExclusiveAttributes((String[][])new String[][]{{"url", "connectionTimeout", "transactionIsolation", "useXaTransactions"}, {"dataSource-ref"}})));
        DbConfigDefinitionParser oracleDbConfigFactoryBean = new DbConfigDefinitionParser(OracleConfigFactoryBean.class, new CheckExclusiveAttributes((String[][])new String[][]{{"url", "connectionTimeout", "transactionIsolation", "useXaTransactions"}, {"dataSource-ref"}}));
        oracleDbConfigFactoryBean.registerPreProcessor((PreProcessor)new CheckRequiredAttributes((String[][])new String[][]{{"dataSource-ref"}, {"user", "password"}}));
        oracleDbConfigFactoryBean.addAlias("instance", "database");
        this.registerBeanDefinitionParser("oracle-config", (BeanDefinitionParser)oracleDbConfigFactoryBean);
        this.registerBeanDefinitionParser("mysql-config", (BeanDefinitionParser)new DbConfigDefinitionParser(MySqlConfigFactoryBean.class, new CheckExclusiveAttributes((String[][])new String[][]{{"url", "connectionTimeout", "transactionIsolation", "useXaTransactions"}, {"host", "port", "database", "connectionTimeout", "transactionIsolation", "useXaTransactions"}, {"dataSource-ref"}})));
        this.registerIgnoredElement("connection-properties");
        this.registerIgnoredElement("property");
        this.registerIgnoredElement("data-types");
        this.registerIgnoredElement("data-type");
    }

    private void registerIgnoredElement(String name) {
        this.registerBeanDefinitionParser(name, (BeanDefinitionParser)new AbstractMuleNamespaceHandler.IgnoredDefinitionParser());
    }
}

