/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.processor;

import java.sql.SQLException;
import java.util.List;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.common.Result;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.metadata.NullMetadataProvider;
import org.mule.module.db.internal.metadata.QueryMetadataProvider;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.util.StringUtils;

public abstract class AbstractDbMessageProcessor
extends AbstractInterceptingMessageProcessor
implements Initialisable,
InterceptingMessageProcessor,
OperationMetaDataEnabled {
    protected final DbConfigResolver dbConfigResolver;
    private final TransactionalAction transactionalAction;
    private QueryMetadataProvider queryMetadataProvider = new NullMetadataProvider();
    private String source;
    private String target;

    public AbstractDbMessageProcessor(DbConfigResolver dbConfigResolver, TransactionalAction transactionalAction) {
        this.dbConfigResolver = dbConfigResolver;
        this.transactionalAction = transactionalAction;
    }

    public MuleEvent process(MuleEvent muleEvent) throws MuleException {
        DbConnection connection = null;
        DbConfig dbConfig = this.dbConfigResolver.resolve(muleEvent);
        try {
            connection = dbConfig.getConnectionFactory().createConnection(this.transactionalAction);
            Object result = this.executeQuery(connection, muleEvent);
            if (this.target == null || "".equals(this.target) || "#[payload]".equals(this.target)) {
                muleEvent.getMessage().setPayload(result);
            } else {
                this.muleContext.getExpressionManager().enrich(this.target, muleEvent, result);
            }
            MuleEvent muleEvent2 = this.processNext(muleEvent);
            return muleEvent2;
        }
        catch (SQLException e) {
            throw new MessagingException(muleEvent, (Throwable)e);
        }
        finally {
            if (connection != null && this.mustCloseConnection()) {
                dbConfig.getConnectionFactory().releaseConnection(connection);
            }
        }
    }

    protected boolean mustCloseConnection() {
        return true;
    }

    protected MuleEvent resolveSource(MuleEvent muleEvent) {
        MuleEvent eventToUse = muleEvent;
        if (!StringUtils.isEmpty((String)this.source) && !"#[payload]".equals(this.source)) {
            Object payload = this.muleContext.getExpressionManager().evaluate(this.source, muleEvent);
            DefaultMuleMessage itemMessage = new DefaultMuleMessage(payload, this.muleContext);
            eventToUse = new DefaultMuleEvent((MuleMessage)itemMessage, muleEvent);
        }
        return eventToUse;
    }

    protected abstract Object executeQuery(DbConnection var1, MuleEvent var2) throws SQLException;

    public void initialise() throws InitialisationException {
    }

    public void setQueryMetadataProvider(QueryMetadataProvider queryMetadataProvider) {
        this.queryMetadataProvider = queryMetadataProvider;
    }

    public QueryMetadataProvider getQueryMetadataProvider() {
        return this.queryMetadataProvider;
    }

    public Result<MetaData> getOutputMetaData(MetaData metaData) {
        return this.queryMetadataProvider.getOutputMetaData(metaData);
    }

    public Result<MetaData> getInputMetaData() {
        return this.queryMetadataProvider.getInputMetaData();
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    protected void validateQueryType(QueryTemplate queryTemplate) {
        List<QueryType> validTypes = this.getValidQueryTypes();
        if (validTypes == null || !validTypes.contains((Object)queryTemplate.getType())) {
            throw new IllegalArgumentException(String.format("Query type must me '%s' but was '%s'", new Object[]{validTypes, queryTemplate.getType()}));
        }
    }

    protected abstract List<QueryType> getValidQueryTypes();
}

