/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sqlexecutor.executor;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.mule.module.db.sqlexecutor.command.InputSqlParamValue;
import org.mule.module.db.sqlexecutor.command.SqlCommand;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.sqlexecutor.executor.AbstractExecutor;
import org.mule.module.db.sqlexecutor.executor.AutoGeneratedKey;
import org.mule.module.db.sqlexecutor.statement.SqlStatementFactory;

public class BatchUpdateExecutor
extends AbstractExecutor {
    public BatchUpdateExecutor(SqlStatementFactory statementFactory) {
        super(statementFactory);
    }

    @Override
    protected Object executeSqlCommand(DbConnection connection, Statement statement, SqlCommand sqlCommand) throws SQLException {
        return this.executeSqlCommand(connection, statement, sqlCommand, null);
    }

    @Override
    protected Object executeSqlCommand(DbConnection dbConnection, Statement statement, SqlCommand sqlCommand, AutoGeneratedKey autoGeneratedKey) throws SQLException {
        String[] split;
        for (String sql : split = sqlCommand.getSqlCommandDefinition().getSqlText().split(";")) {
            statement.addBatch(sql);
        }
        return statement.executeBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeBatch(DbConnection connection, List<SqlCommand> sqlCommands) throws SQLException {
        Statement statement = this.statementFactory.create(connection, sqlCommands.get(0).getSqlCommandDefinition());
        try {
            for (SqlCommand sqlCommand : sqlCommands) {
                statement.addBatch(sqlCommand.getSqlCommandDefinition().getSqlText());
            }
            int[] nArray = statement.executeBatch();
            return nArray;
        }
        finally {
            statement.clearBatch();
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeBatch(DbConnection connection, SqlCommand sqlCommand, List<List<InputSqlParamValue>> paramValues) throws SQLException {
        Statement statement = this.statementFactory.create(connection, sqlCommand.getSqlCommandDefinition());
        if (!(statement instanceof PreparedStatement)) {
            throw new IllegalArgumentException("Batch must be executed on a prepared statement");
        }
        PreparedStatement preparedStatement = (PreparedStatement)statement;
        try {
            for (List<InputSqlParamValue> params : paramValues) {
                this.doProcessParameters(preparedStatement, sqlCommand.getSqlCommandDefinition().getParams(), params);
                preparedStatement.addBatch();
            }
            int[] nArray = preparedStatement.executeBatch();
            return nArray;
        }
        finally {
            preparedStatement.clearParameters();
            statement.close();
        }
    }
}

