/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sqlexecutor.connection;

import java.sql.Connection;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.sqlexecutor.connection.DefaultDbConnectionReleaseListener;
import org.mule.module.db.sqlexecutor.resulthandler.GenericStatementResultIteratorFactory;
import org.mule.module.db.sqlexecutor.resulthandler.ResultSetHandler;
import org.mule.module.db.sqlexecutor.resulthandler.StatementResultIteratorFactory;
import org.mule.module.db.transaction.TransactionalAction;

public abstract class AbstractDbConnection
implements DbConnection {
    private final TransactionalAction transactionalAction;
    private DefaultDbConnectionReleaseListener connectionReleaseListener;
    protected final Connection delegate;

    public AbstractDbConnection(Connection delegate, TransactionalAction transactionalAction, DefaultDbConnectionReleaseListener connectionReleaseListener) {
        this.delegate = delegate;
        this.transactionalAction = transactionalAction;
        this.connectionReleaseListener = connectionReleaseListener;
    }

    @Override
    public Connection getDelegate() {
        return this.delegate;
    }

    @Override
    public StatementResultIteratorFactory getStatementResultIteratorFactory(ResultSetHandler resultSetHandler) {
        return new GenericStatementResultIteratorFactory(resultSetHandler);
    }

    @Override
    public TransactionalAction getTransactionalAction() {
        return this.transactionalAction;
    }

    @Override
    public void release() {
        this.connectionReleaseListener.notify(this);
    }
}

