/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sqlexecutor.command;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.mule.module.db.sqlexecutor.command.SqlCommandType;
import org.mule.module.db.sqlexecutor.param.InputSqlParam;
import org.mule.module.db.sqlexecutor.param.OutputSqlParam;
import org.mule.module.db.sqlexecutor.param.SqlParam;
import org.mule.util.StringUtils;

public class SqlCommandDefinition {
    private final String sqlText;
    private final List<InputSqlParam> inputParams;
    private final List<OutputSqlParam> outputParams;
    private final List<SqlParam> params;
    private final SqlCommandType type;
    private final boolean dynamic;
    private final boolean namedParams;

    public SqlCommandDefinition(String sqlText, SqlCommandType type, List<SqlParam> params) {
        this(sqlText, type, params, false);
    }

    public SqlCommandDefinition(String sqlText, SqlCommandType type, List<SqlParam> params, boolean dynamic) {
        Validate.notEmpty((String)sqlText);
        this.sqlText = sqlText;
        Validate.notNull((Object)((Object)type));
        this.type = type;
        this.inputParams = this.filterInputSqlParams(params);
        this.outputParams = this.filterOutputSqlParams(params);
        this.params = Collections.unmodifiableList(params);
        this.dynamic = dynamic;
        this.namedParams = this.usesNamedParams();
    }

    public SqlCommandDefinition(SqlCommandDefinition source) {
        this.sqlText = source.sqlText;
        this.type = source.type;
        this.inputParams = source.inputParams;
        this.outputParams = source.outputParams;
        this.params = source.params;
        this.dynamic = source.dynamic;
        this.namedParams = source.namedParams;
    }

    private boolean usesNamedParams() {
        boolean firstParam = true;
        boolean namedParams = false;
        for (InputSqlParam inputParam : this.inputParams) {
            if (firstParam) {
                namedParams = !StringUtils.isEmpty((String)inputParam.getName());
                firstParam = false;
                continue;
            }
            if (namedParams == !StringUtils.isEmpty((String)inputParam.getName())) continue;
            throw new IllegalArgumentException("Cannot mix named and inline parameters in the same query");
        }
        return namedParams;
    }

    private List<InputSqlParam> filterInputSqlParams(List<SqlParam> inputParams) {
        LinkedList<InputSqlParam> result = new LinkedList<InputSqlParam>();
        for (SqlParam param : inputParams) {
            if (!(param instanceof InputSqlParam)) continue;
            result.add((InputSqlParam)param);
        }
        return result;
    }

    private List<OutputSqlParam> filterOutputSqlParams(List<SqlParam> inputParams) {
        LinkedList<OutputSqlParam> result = new LinkedList<OutputSqlParam>();
        for (SqlParam param : inputParams) {
            if (!(param instanceof OutputSqlParam)) continue;
            result.add((OutputSqlParam)param);
        }
        return result;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public List<InputSqlParam> getInputParams() {
        return this.inputParams;
    }

    public List<OutputSqlParam> getOutputParams() {
        return this.outputParams;
    }

    public List<SqlParam> getParams() {
        return this.params;
    }

    public SqlCommandType getType() {
        return this.type;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean usesNamedParameters() {
        return this.namedParams;
    }
}

