/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.processor;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.module.db.processor.AbstractDbMessageProcessor;
import org.mule.module.db.resolver.BatchSqlCommandResolver;
import org.mule.module.db.sqlexecutor.command.BulkSqlCommand;
import org.mule.module.db.sqlexecutor.command.SqlCommand;
import org.mule.module.db.sqlexecutor.command.SqlCommandType;
import org.mule.module.db.sqlexecutor.connection.DbConfigResolver;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.sqlexecutor.executor.BatchUpdateExecutor;
import org.mule.module.db.sqlexecutor.executor.CommandExecutorFactory;
import org.mule.module.db.transaction.TransactionalAction;

public class BulkUpdateMessageProcessor
extends AbstractDbMessageProcessor {
    private final BatchSqlCommandResolver batchSqlCommandResolver;
    private final CommandExecutorFactory<BatchUpdateExecutor> batchUpdateExecutorFactory;
    private final List<SqlCommandType> validSqlCommandTypes;

    public BulkUpdateMessageProcessor(DbConfigResolver dbConfigResolver, BatchSqlCommandResolver batchSqlCommandResolver, CommandExecutorFactory<BatchUpdateExecutor> batchUpdateExecutorFactory, TransactionalAction transactionalAction) {
        super(dbConfigResolver, transactionalAction);
        this.batchSqlCommandResolver = batchSqlCommandResolver;
        this.batchUpdateExecutorFactory = batchUpdateExecutorFactory;
        this.validSqlCommandTypes = new ArrayList<SqlCommandType>();
        this.validSqlCommandTypes.add(SqlCommandType.UPDATE);
        this.validSqlCommandTypes.add(SqlCommandType.INSERT);
        this.validSqlCommandTypes.add(SqlCommandType.DELETE);
        this.validSqlCommandTypes.add(SqlCommandType.DDL);
    }

    private void validateCommands(List<SqlCommand> sqlCommands) {
        for (SqlCommand sqlCommand : sqlCommands) {
            this.validateCommandType(sqlCommand.getSqlCommandDefinition());
        }
    }

    @Override
    protected Object executeSqlCommand(DbConnection connection, MuleEvent muleEvent) throws SQLException, MuleException {
        MuleEvent eventToUse = this.resolveSource(muleEvent);
        BulkSqlCommand bulkSqlCommand = this.batchSqlCommandResolver.resolve(eventToUse);
        this.validateCommands(bulkSqlCommand.getCommands());
        BatchUpdateExecutor commandExecutor = this.batchUpdateExecutorFactory.create(connection);
        return commandExecutor.executeBatch(connection, bulkSqlCommand.getCommands());
    }

    @Override
    protected List<SqlCommandType> getValidSqlCommandTypes() {
        return this.validSqlCommandTypes;
    }
}

