/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.processor;

import java.sql.SQLException;
import java.util.List;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.common.Result;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.module.db.metadata.MetadataProvider;
import org.mule.module.db.metadata.NullMetadataProvider;
import org.mule.module.db.sqlexecutor.command.SqlCommandDefinition;
import org.mule.module.db.sqlexecutor.command.SqlCommandType;
import org.mule.module.db.sqlexecutor.connection.DbConfig;
import org.mule.module.db.sqlexecutor.connection.DbConfigResolver;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.transaction.TransactionalAction;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.util.StringUtils;

public abstract class AbstractDbMessageProcessor
extends AbstractInterceptingMessageProcessor
implements Initialisable,
InterceptingMessageProcessor,
OperationMetaDataEnabled {
    protected final DbConfigResolver dbConfigResolver;
    private TransactionalAction transactionalAction;
    private MetadataProvider metadataProvider = new NullMetadataProvider();
    private String source;
    private String target;

    public AbstractDbMessageProcessor(DbConfigResolver dbConfigResolver, TransactionalAction transactionalAction) {
        this.dbConfigResolver = dbConfigResolver;
        this.transactionalAction = transactionalAction;
    }

    public MuleEvent process(MuleEvent muleEvent) throws MuleException {
        DbConnection connection = null;
        DbConfig dbConfig = this.dbConfigResolver.resolve(muleEvent);
        try {
            MuleEvent muleEvent1;
            connection = dbConfig.getConnectionFactory().createConnection(this.transactionalAction);
            Object result = this.executeSqlCommand(connection, muleEvent);
            if (this.target == null || "".equals(this.target) || "#[payload]".equals(this.target)) {
                muleEvent.getMessage().setPayload(result);
            } else {
                this.muleContext.getExpressionManager().enrich(this.target, muleEvent, result);
            }
            MuleEvent muleEvent2 = muleEvent1 = this.processNext(muleEvent);
            return muleEvent2;
        }
        catch (SQLException e) {
            throw new DefaultMuleException((Throwable)e);
        }
        finally {
            if (connection != null && this.mustCloseConnection()) {
                dbConfig.getConnectionFactory().releaseConnection(connection);
            }
        }
    }

    protected boolean mustCloseConnection() {
        return true;
    }

    protected MuleEvent resolveSource(MuleEvent muleEvent) {
        MuleEvent eventToUse = muleEvent;
        if (!StringUtils.isEmpty((String)this.source) && !"#[payload]".equals(this.source)) {
            Object payload = this.muleContext.getExpressionManager().evaluate(this.source, muleEvent);
            DefaultMuleMessage itemMessage = new DefaultMuleMessage(payload, this.muleContext);
            eventToUse = new DefaultMuleEvent((MuleMessage)itemMessage, muleEvent);
        }
        return eventToUse;
    }

    protected abstract Object executeSqlCommand(DbConnection var1, MuleEvent var2) throws SQLException, MuleException;

    public void initialise() throws InitialisationException {
    }

    public void setMetadataProvider(MetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    public MetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public Result<MetaData> getOutputMetaData(MetaData metaData) {
        return this.metadataProvider.getOutputMetaData(metaData);
    }

    public Result<MetaData> getInputMetaData() {
        return this.metadataProvider.getInputMetaData();
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    protected void validateCommandType(SqlCommandDefinition sqlCommandDefinition) {
        List<SqlCommandType> validTypes = this.getValidSqlCommandTypes();
        if (validTypes == null || !validTypes.contains((Object)sqlCommandDefinition.getType())) {
            throw new IllegalArgumentException(String.format("Command type must me '%s' but was '%s'", new Object[]{validTypes, sqlCommandDefinition.getType()}));
        }
    }

    protected abstract List<SqlCommandType> getValidSqlCommandTypes();
}

