/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.config.database;

import javax.sql.DataSource;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.module.db.sqlexecutor.connection.DbConfig;
import org.mule.module.db.sqlexecutor.connection.DbPoolingProfile;
import org.mule.module.db.sqlexecutor.connection.DefaultDbConfig;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class DbConfigFactoryBean
extends AbstractFactoryBean<DbConfig>
implements MuleContextAware,
Initialisable {
    private String name;
    private String url;
    private String driverClassName;
    private int connectionTimeout;
    private String password;
    private String user;
    private int transactionIsolation = -1;
    private DataSource dataSource;
    private MuleContext muleContext;
    private boolean useXaTransactions;
    private DbPoolingProfile poolingProfile;
    private DefaultDbConfig jdbcConfig;

    public Class<?> getObjectType() {
        return DefaultDbConfig.class;
    }

    protected DbConfig createInstance() throws Exception {
        this.jdbcConfig = this.doCreateJdbcConfig(this.dataSource);
        this.jdbcConfig.setPoolingProfile(this.poolingProfile);
        this.jdbcConfig.setUseXaTransactions(this.useXaTransactions);
        this.jdbcConfig.setUrl(this.getEffectiveUrl());
        this.jdbcConfig.setConnectionTimeout(this.connectionTimeout);
        this.jdbcConfig.setUsername(this.user);
        this.jdbcConfig.setPassword(this.password);
        this.jdbcConfig.setTransactionIsolation(this.transactionIsolation);
        this.jdbcConfig.setDriverClassName(this.driverClassName);
        this.jdbcConfig.setMuleContext(this.muleContext);
        return this.jdbcConfig;
    }

    protected DefaultDbConfig doCreateJdbcConfig(DataSource datasource) {
        return new DefaultDbConfig(datasource, this.name);
    }

    protected String getEffectiveUrl() {
        return this.url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTransactionIsolation(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    public void setconnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void setUseXaTransactions(boolean useXaTransactions) {
        this.useXaTransactions = useXaTransactions;
    }

    public void setPoolingProfile(DbPoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }

    public void initialise() throws InitialisationException {
        this.jdbcConfig.initialise();
    }
}

