/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.config;

import org.mule.config.spring.parsers.AbstractHierarchicalDefinitionParser;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.module.db.config.database.DefaultDbConfigResolverFactoryBean;
import org.mule.module.db.sqlexecutor.connection.ConstantDbConfigResolver;
import org.mule.module.db.sqlexecutor.connection.DynamicDbConfigResolver;
import org.mule.module.db.sqlexecutor.statement.SimpleStatementFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AbstractDbProcessorDefinitionParser
extends AbstractHierarchicalDefinitionParser {
    public static final String LIST_SEPARATOR = ",";
    public static final String CONFIG_PROPERTY = "config-ref";
    public static final String STATEMENT_FACTORY_REF_ATTRIBUTE = "statementFactory-ref";
    public static final String MAX_ROWS_ATTRIBUTE = "maxRows";
    protected BeanDefinition jdbcConfigResolverFactoryBeanDefinition;

    protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        builder.setScope(this.isSingleton() ? "singleton" : "prototype");
        this.doParseElement(element, context, builder);
        BeanAssembler assembler = this.getBeanAssembler(element, builder);
        assembler.insertBeanInTarget("messageProcessor");
    }

    protected abstract void doParseElement(Element var1, ParserContext var2, BeanDefinitionBuilder var3);

    protected void parseConfig(Element element, BeanDefinitionBuilder builder) {
        BeanDefinitionBuilder wrapper;
        String config = element.getAttribute(CONFIG_PROPERTY);
        if ("".equals(config)) {
            wrapper = BeanDefinitionBuilder.genericBeanDefinition(DefaultDbConfigResolverFactoryBean.class);
        } else if (config.startsWith("#[")) {
            wrapper = BeanDefinitionBuilder.genericBeanDefinition(DynamicDbConfigResolver.class);
            wrapper.addConstructorArgValue((Object)config);
        } else {
            wrapper = BeanDefinitionBuilder.genericBeanDefinition(ConstantDbConfigResolver.class);
            wrapper.addConstructorArgReference(config);
        }
        this.jdbcConfigResolverFactoryBeanDefinition = wrapper.getBeanDefinition();
        builder.addConstructorArgValue((Object)this.jdbcConfigResolverFactoryBeanDefinition);
    }

    protected void parseSourceExpression(Element element, BeanDefinitionBuilder builder) {
        builder.addPropertyValue("source", (Object)element.getAttribute("source"));
    }

    protected void parseTargetExpression(Element element, BeanDefinitionBuilder builder) {
        builder.addPropertyValue("target", (Object)element.getAttribute("target"));
    }

    protected Object parseStatementFactory(Element element) {
        Object result;
        if (element.hasAttribute(STATEMENT_FACTORY_REF_ATTRIBUTE)) {
            result = new RuntimeBeanReference(element.getAttribute(STATEMENT_FACTORY_REF_ATTRIBUTE));
        } else {
            SimpleStatementFactory simpleStatementFactory = new SimpleStatementFactory();
            if (element.hasAttribute(MAX_ROWS_ATTRIBUTE)) {
                simpleStatementFactory.setMaxRows(Integer.parseInt(element.getAttribute(MAX_ROWS_ATTRIBUTE)));
            }
            result = simpleStatementFactory;
        }
        return result;
    }
}

