/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.config;

import org.mule.module.db.config.AbstractDbProcessorDefinitionParser;
import org.mule.module.db.config.ParameterizedQueryDefinitionParser;
import org.mule.module.db.sqlexecutor.executor.AutoGeneratedKey;
import org.mule.module.db.sqlexecutor.executor.ColumnIndexAutoGeneratedKey;
import org.mule.module.db.sqlexecutor.executor.ColumnNameAutoGeneratedKey;
import org.mule.module.db.sqlexecutor.executor.DefaultAutoGeneratedKey;
import org.mule.module.db.sqlexecutor.executor.NoAutoGeneratedKey;
import org.mule.module.db.transaction.TransactionalAction;
import org.mule.util.StringUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;

public abstract class AbstractAdvancedDbProcessorDefinitionParser
extends AbstractDbProcessorDefinitionParser {
    public static final String AUTO_GENERATED_KEYS_PROPERTY = "autoGeneratedKeys";
    public static final String COLUMN_INDEXES_PROPERTY = "autoGeneratedKeysColumnIndexes";
    public static final String COLUMN_NAMES_PROPERTY = "autoGeneratedKeysColumnNames";
    protected ParameterizedQueryDefinitionParser parameterizedQueryDefinitionParser = new ParameterizedQueryDefinitionParser();
    protected AutoGeneratedKey autoGeneratedKey;

    protected abstract Object createExecutorFactory(Element var1);

    protected abstract Object getMetadataProvider();

    protected void parseExecutorFactory(Element element, BeanDefinitionBuilder builder) {
        builder.addConstructorArgValue(this.createExecutorFactory(element));
    }

    protected void parseTransactionalAction(Element element, BeanDefinitionBuilder builder) {
        builder.addConstructorArgValue((Object)TransactionalAction.valueOf(element.getAttribute("transactionalAction")));
    }

    protected void parseAutoGeneratedKeys(Element element, BeanDefinitionBuilder builder) {
        boolean autoGeneratedKeysAttribute = false;
        if (element.hasAttribute(AUTO_GENERATED_KEYS_PROPERTY)) {
            autoGeneratedKeysAttribute = Boolean.parseBoolean(element.getAttribute(AUTO_GENERATED_KEYS_PROPERTY));
        }
        if (autoGeneratedKeysAttribute) {
            String columnIndexesAttribute = null;
            if (element.hasAttribute(COLUMN_INDEXES_PROPERTY)) {
                columnIndexesAttribute = element.getAttribute(COLUMN_INDEXES_PROPERTY);
            }
            String columnNamesAttribute = null;
            if (element.hasAttribute(COLUMN_NAMES_PROPERTY)) {
                columnNamesAttribute = element.getAttribute(COLUMN_NAMES_PROPERTY);
            }
            if (!StringUtils.isEmpty((String)columnIndexesAttribute)) {
                int[] columnIndexes = new int[columnIndexesAttribute.length()];
                int i = 0;
                for (String stringIndex : columnIndexesAttribute.split(",")) {
                    columnIndexes[i++] = Integer.parseInt(stringIndex);
                }
                this.autoGeneratedKey = new ColumnIndexAutoGeneratedKey(columnIndexes);
            } else if (!StringUtils.isEmpty((String)columnNamesAttribute)) {
                String[] columnNames = columnNamesAttribute.split(",");
                this.autoGeneratedKey = new ColumnNameAutoGeneratedKey(columnNames);
            } else {
                this.autoGeneratedKey = new DefaultAutoGeneratedKey();
            }
        } else {
            this.autoGeneratedKey = new NoAutoGeneratedKey();
        }
        builder.getBeanDefinition().getPropertyValues().add("autoGeneratedKey", (Object)this.autoGeneratedKey);
    }

    protected void parseMetadataProvider(Element element, BeanDefinitionBuilder builder) {
        if (!element.hasAttribute("metadataProvider")) {
            builder.addPropertyValue("metadataProvider", this.getMetadataProvider());
        }
    }
}

