/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sqlexecutor.command;

import java.util.LinkedList;
import java.util.List;
import org.mule.module.db.sqlexecutor.command.InputSqlParamValue;
import org.mule.module.db.sqlexecutor.command.SqlCommandDefinition;
import org.mule.module.db.sqlexecutor.param.InputSqlParam;

public class SqlCommand {
    private SqlCommandDefinition sqlCommandDefinition;
    private List<InputSqlParamValue> paramValues;

    public SqlCommand(SqlCommandDefinition sqlCommandDefinition, List<InputSqlParamValue> paramValues) {
        this.paramValues = paramValues;
        this.sqlCommandDefinition = sqlCommandDefinition;
    }

    public SqlCommand(SqlCommand sqlCommand) {
        this.paramValues = sqlCommand.getParamValues();
        this.sqlCommandDefinition = sqlCommand.getSqlCommandDefinition();
    }

    public SqlCommand(SqlCommandDefinition sqlCommandDefinition) {
        this.sqlCommandDefinition = sqlCommandDefinition;
        this.paramValues = new LinkedList<InputSqlParamValue>();
        for (InputSqlParam inputParam : sqlCommandDefinition.getInputParams()) {
            InputSqlParamValue paramValue = new InputSqlParamValue();
            paramValue.setValue(inputParam.getValue());
            this.paramValues.add(paramValue);
        }
    }

    public SqlCommandDefinition getSqlCommandDefinition() {
        return this.sqlCommandDefinition;
    }

    public List<InputSqlParamValue> getParamValues() {
        return this.paramValues;
    }

    public boolean isDynamic() {
        return this.sqlCommandDefinition.isDynamic();
    }
}

