/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.processor;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.mule.module.db.processor.AbstractSingleCommandDbMessageProcessor;
import org.mule.module.db.resolver.SqlCommandResolver;
import org.mule.module.db.sqlexecutor.command.SqlCommand;
import org.mule.module.db.sqlexecutor.command.SqlCommandType;
import org.mule.module.db.sqlexecutor.connection.DbConfigResolver;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.sqlexecutor.executor.AutoGeneratedKey;
import org.mule.module.db.sqlexecutor.executor.CommandExecutorFactory;
import org.mule.module.db.transaction.TransactionalAction;

public class StoredProcedureMessageProcessor
extends AbstractSingleCommandDbMessageProcessor {
    private final CommandExecutorFactory commandExecutorFactory;
    private final boolean streaming;
    private final List<SqlCommandType> sqlCommandTypes;
    private AutoGeneratedKey autoGeneratedKey;

    public StoredProcedureMessageProcessor(DbConfigResolver dbConfigResolver, SqlCommandResolver sqlCommandResolver, CommandExecutorFactory commandExecutorFactory, TransactionalAction transactionalAction, boolean streaming) {
        super(dbConfigResolver, sqlCommandResolver, transactionalAction);
        this.commandExecutorFactory = commandExecutorFactory;
        this.streaming = streaming;
        this.sqlCommandTypes = Collections.singletonList(SqlCommandType.STORE_PROCEDURE_CALL);
    }

    @Override
    protected boolean mustCloseConnection() {
        return !this.streaming;
    }

    @Override
    protected Object doExecuteSqlCommand(DbConnection connection, SqlCommand sqlCommand) throws SQLException {
        Object commandExecutor = this.commandExecutorFactory.create(connection);
        return commandExecutor.execute(connection, sqlCommand, this.autoGeneratedKey);
    }

    @Override
    protected List<SqlCommandType> getValidSqlCommandTypes() {
        return this.sqlCommandTypes;
    }

    public void setAutoGeneratedKey(AutoGeneratedKey autoGeneratedKey) {
        this.autoGeneratedKey = autoGeneratedKey;
    }
}

