/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.processor;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.module.db.processor.AbstractDbMessageProcessor;
import org.mule.module.db.resolver.DefaultSqlParamResolver;
import org.mule.module.db.resolver.SqlCommandResolver;
import org.mule.module.db.sqlexecutor.command.InputSqlParamValue;
import org.mule.module.db.sqlexecutor.command.SqlCommand;
import org.mule.module.db.sqlexecutor.command.SqlCommandType;
import org.mule.module.db.sqlexecutor.connection.DbConfigResolver;
import org.mule.module.db.sqlexecutor.connection.DbConnection;
import org.mule.module.db.sqlexecutor.executor.AutoGeneratedKey;
import org.mule.module.db.sqlexecutor.executor.BatchUpdateExecutor;
import org.mule.module.db.sqlexecutor.executor.CommandExecutorFactory;
import org.mule.module.db.transaction.TransactionalAction;

public class PreparedBatchUpdateMessageProcessor
extends AbstractDbMessageProcessor {
    private final SqlCommandResolver sqlCommandResolver;
    private final CommandExecutorFactory<BatchUpdateExecutor> batchUpdateExecutorFactory;
    private List<SqlCommandType> validSqlCommandTypes;
    private String source;
    private AutoGeneratedKey autoGeneratedKey;

    public PreparedBatchUpdateMessageProcessor(DbConfigResolver dbConfigResolver, SqlCommandResolver sqlCommandResolver, CommandExecutorFactory<BatchUpdateExecutor> batchUpdateExecutorFactory, TransactionalAction transactionalAction, List<SqlCommandType> validSqlCommandTypes) {
        super(dbConfigResolver, transactionalAction);
        this.sqlCommandResolver = sqlCommandResolver;
        this.batchUpdateExecutorFactory = batchUpdateExecutorFactory;
        this.validSqlCommandTypes = validSqlCommandTypes;
    }

    @Override
    protected Object executeSqlCommand(DbConnection connection, MuleEvent muleEvent) throws SQLException, MuleException {
        SqlCommand sqlCommand = this.sqlCommandResolver.resolve(muleEvent);
        this.validateCommandType(sqlCommand.getSqlCommandDefinition());
        List<List<InputSqlParamValue>> paramValues = this.resolveParamSets(muleEvent, sqlCommand);
        BatchUpdateExecutor batchUpdateExecutor = this.batchUpdateExecutorFactory.create(connection);
        return batchUpdateExecutor.executeBatch(connection, sqlCommand, paramValues);
    }

    private List<List<InputSqlParamValue>> resolveParamSets(MuleEvent muleEvent, SqlCommand sqlCommand) {
        LinkedList<List<InputSqlParamValue>> result = new LinkedList<List<InputSqlParamValue>>();
        Object payload = this.source == null || this.source.equals("") ? muleEvent.getMessage().getPayload() : this.muleContext.getExpressionManager().evaluate(this.source, muleEvent);
        DefaultSqlParamResolver sqlParamResolver = new DefaultSqlParamResolver(this.muleContext.getExpressionManager());
        if (payload instanceof Collection) {
            Collection collection = (Collection)payload;
            for (Object aCollection : collection) {
                DefaultMuleMessage itemMessage = new DefaultMuleMessage(aCollection, this.muleContext);
                DefaultMuleEvent itemEvent = new DefaultMuleEvent((MuleMessage)itemMessage, muleEvent);
                List<InputSqlParamValue> inputSqlParamValues = sqlParamResolver.resolveParams((MuleEvent)itemEvent, sqlCommand.getParamValues());
                result.add(inputSqlParamValues);
            }
        } else {
            List<InputSqlParamValue> inputSqlParamValues = sqlParamResolver.resolveParams(muleEvent, sqlCommand.getParamValues());
            result.add(inputSqlParamValues);
        }
        return result;
    }

    @Override
    protected List<SqlCommandType> getValidSqlCommandTypes() {
        return this.validSqlCommandTypes;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    public AutoGeneratedKey getAutoGeneratedKey() {
        return this.autoGeneratedKey;
    }

    public void setAutoGeneratedKey(AutoGeneratedKey autoGeneratedKey) {
        this.autoGeneratedKey = autoGeneratedKey;
    }
}

