/*
 * Decompiled with CFR 0.152.
 */
package org.mule.compatibility.module.cxf.support;

import java.util.Iterator;
import java.util.List;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.SoapVersionFactory;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;

public final class CxfUtils {
    public static boolean removeInterceptor(List<Interceptor<? extends Message>> inInterceptors, String name) {
        for (Interceptor<? extends Message> i : inInterceptors) {
            PhaseInterceptor p;
            if (!(i instanceof PhaseInterceptor) || !(p = (PhaseInterceptor)i).getId().equals(name)) continue;
            inInterceptors.remove(p);
            return true;
        }
        return false;
    }

    public static String getBindingIdForSoapVersion(String version) {
        Iterator soapVersions = SoapVersionFactory.getInstance().getVersions();
        while (soapVersions.hasNext()) {
            SoapVersion soapVersion = (SoapVersion)soapVersions.next();
            if (!Double.toString(soapVersion.getVersion()).equals(version)) continue;
            return soapVersion.getBindingId();
        }
        throw new IllegalArgumentException("Invalid Soap version " + version);
    }

    public static String mapUnsupportedSchemas(String url) {
        if (url != null) {
            url = url.replace("servlet://", "http://");
            url = url.replace("jetty://", "http://");
            url = url.replace("jetty-ssl://", "https://");
        }
        return url;
    }
}

