/*
 * Decompiled with CFR 0.152.
 */
package org.mule.compatibility.module.cxf;

import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MuleSoapHeaders {
    private String replyTo;
    private String correlationId;
    private String correlationGroup;
    private String correlationSequence;
    public static final String MULE_10_ACTOR = "http://www.muleumo.org/providers/soap/1.0";
    public static final String MULE_NAMESPACE = "mule";
    public static final String MULE_HEADER = "header";
    public static final String ENV_REQUEST_HEADERS = "MULE_REQUEST_HEADERS";

    public MuleSoapHeaders(Event event) {
        if (event.getContext().isCorrelationIdFromSource() || !event.getCorrelationId().equals(event.getContext().getCorrelationId())) {
            this.setCorrelationId(event.getCorrelationId());
        }
        event.getGroupCorrelation().getGroupSize().map(v -> v.toString()).ifPresent(v -> this.setCorrelationGroup((String)v));
        event.getGroupCorrelation().getSequence().map(v -> v.toString()).ifPresent(v -> this.setCorrelationSequence((String)v));
    }

    public MuleSoapHeaders(SOAPHeader soapHeader) {
        Iterator iter = soapHeader.examineHeaderElements(MULE_10_ACTOR);
        while (iter.hasNext()) {
            SOAPHeaderElement headerElement = (SOAPHeaderElement)iter.next();
            if (!StringUtils.equals((String)MULE_10_ACTOR, (String)headerElement.getNamespaceURI())) continue;
            Iterator iter2 = headerElement.getChildElements();
            this.readElements(iter2);
        }
    }

    public MuleSoapHeaders(Iterator elements) {
        this.readElements(elements);
    }

    protected void readElements(Iterator elements) {
        while (elements.hasNext()) {
            Object elementObject = elements.next();
            if (!(elementObject instanceof SOAPElement)) continue;
            SOAPElement element = (SOAPElement)elementObject;
            String localName = element.getLocalName();
            String elementValue = this.getStringValue((Element)element);
            if ("MULE_CORRELATION_ID".equals(localName)) {
                this.correlationId = elementValue;
                continue;
            }
            if ("MULE_CORRELATION_GROUP_SIZE".equals(localName)) {
                this.correlationGroup = elementValue;
                continue;
            }
            if ("MULE_CORRELATION_SEQUENCE".equals(localName)) {
                this.correlationSequence = elementValue;
                continue;
            }
            if (!"MULE_REPLYTO".equals(localName)) continue;
            this.replyTo = elementValue;
        }
    }

    private String getStringValue(Element e) {
        String value = e.getNodeValue();
        if (value != null || !e.hasChildNodes() || (value = e.getFirstChild().getNodeValue()) != null) {
            // empty if block
        }
        return value;
    }

    public void addHeaders(SOAPEnvelope env) throws Exception {
        SOAPElement e;
        SOAPHeader header = env.getHeader();
        if (this.correlationId != null || this.replyTo != null) {
            if (header == null) {
                header = env.addHeader();
            }
        } else {
            return;
        }
        Name muleHeaderName = env.createName(MULE_HEADER, MULE_NAMESPACE, MULE_10_ACTOR);
        SOAPHeaderElement muleHeader = header.addHeaderElement(muleHeaderName);
        muleHeader.setActor(MULE_10_ACTOR);
        if (this.correlationId != null) {
            e = muleHeader.addChildElement("MULE_CORRELATION_ID", MULE_NAMESPACE);
            e.addTextNode(this.correlationId);
            e = muleHeader.addChildElement("MULE_CORRELATION_GROUP_SIZE", MULE_NAMESPACE);
            e.addTextNode(this.correlationGroup);
            e = muleHeader.addChildElement("MULE_CORRELATION_SEQUENCE", MULE_NAMESPACE);
            e.addTextNode(this.correlationSequence);
        }
        if (this.replyTo != null) {
            e = muleHeader.addChildElement("MULE_REPLYTO", MULE_NAMESPACE);
            e.addTextNode(this.replyTo);
        }
    }

    public Element createHeaders() throws Exception {
        Node e;
        DOMElement muleHeader = null;
        if (this.correlationId == null && this.replyTo == null) {
            return null;
        }
        muleHeader = new DOMElement(new QName(MULE_HEADER, new Namespace(MULE_NAMESPACE, MULE_10_ACTOR)));
        if (this.correlationId != null) {
            e = muleHeader.appendChild((Node)new DOMElement(new QName("MULE_CORRELATION_ID", new Namespace(MULE_NAMESPACE, MULE_10_ACTOR))));
            e.setNodeValue(this.correlationId);
            e = muleHeader.appendChild((Node)new DOMElement(new QName("MULE_CORRELATION_GROUP_SIZE", new Namespace(MULE_NAMESPACE, MULE_10_ACTOR))));
            e.setNodeValue(this.correlationGroup);
            e = muleHeader.appendChild((Node)new DOMElement(new QName("MULE_CORRELATION_SEQUENCE", new Namespace(MULE_NAMESPACE, MULE_10_ACTOR))));
            e.setNodeValue(this.correlationSequence);
        }
        if (this.replyTo != null) {
            e = muleHeader.appendChild((Node)new DOMElement(new QName("MULE_REPLYTO", new Namespace(MULE_NAMESPACE, MULE_10_ACTOR))));
            e.setNodeValue(this.replyTo);
        }
        return muleHeader;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getCorrelationGroup() {
        return this.correlationGroup;
    }

    public void setCorrelationGroup(String correlationGroup) {
        this.correlationGroup = correlationGroup;
    }

    public String getCorrelationSequence() {
        return this.correlationSequence;
    }

    public void setCorrelationSequence(String correlationSequence) {
        this.correlationSequence = correlationSequence;
    }
}

