/*
 * Decompiled with CFR 0.152.
 */
package org.mule.compatibility.module.cxf.support;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.service.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleProtocolHeadersOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger logger = LoggerFactory.getLogger(MuleProtocolHeadersOutInterceptor.class);

    public MuleProtocolHeadersOutInterceptor() {
        super("pre-stream");
        this.getAfter().add(AttachmentOutInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        Event event = (Event)message.getExchange().get((Object)"mule.event");
        if (event == null) {
            return;
        }
        if (event.getMessage() == null) {
            return;
        }
        InternalMessage.Builder messageBuilder = InternalMessage.builder((org.mule.runtime.api.message.Message)event.getMessage());
        this.extractAndSetContentType(message, messageBuilder);
        this.extractAndSet(message, messageBuilder, Message.RESPONSE_CODE, "http.status");
        String method = (String)message.get((Object)"org.apache.cxf.request.method");
        String finalMethod = method != null ? method : HttpConstants.Method.POST.name();
        messageBuilder.addOutboundProperty("http.method", (Serializable)((Object)finalMethod));
        Map reqHeaders = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (reqHeaders != null) {
            for (Map.Entry e : reqHeaders.entrySet()) {
                String key = (String)e.getKey();
                String val = this.format((List)e.getValue());
                messageBuilder.addOutboundProperty(key, (Serializable)((Object)val));
            }
        }
        event = Event.builder((Event)event).message((org.mule.runtime.api.message.Message)messageBuilder.build()).build();
        message.getExchange().put((Object)"mule.event", (Object)event);
        if (!Boolean.TRUE.equals(message.containsKey((Object)"org.apache.cxf.client"))) {
            message.getInterceptorChain().pause();
        }
    }

    private void extractAndSet(Message message, InternalMessage.Builder builder, String cxfHeader, String muleHeader) {
        if (message.get((Object)cxfHeader) instanceof Serializable) {
            Serializable val = (Serializable)message.get((Object)cxfHeader);
            if (val != null) {
                builder.addOutboundProperty(muleHeader, val);
            }
        } else {
            logger.warn("The header " + cxfHeader + "is not serializable and will not be propagated by Mule");
        }
    }

    private void extractAndSetContentType(Message message, InternalMessage.Builder builder) {
        String ct = (String)message.get((Object)"Content-Type");
        message.getExchange().put((Object)"Content-Type", (Object)ct);
        if (ct != null) {
            builder.mediaType(MediaType.parse((String)ct).withCharset(this.getEncoding(message)));
        }
    }

    private Charset getEncoding(Message message) {
        Exchange ex = message.getExchange();
        String encoding = (String)message.get((Object)Message.ENCODING);
        if (encoding == null && ex.getInMessage() != null) {
            encoding = (String)ex.getInMessage().get((Object)Message.ENCODING);
            message.put((Object)Message.ENCODING, (Object)encoding);
        }
        if (encoding == null) {
            message.put((Object)Message.ENCODING, (Object)StandardCharsets.UTF_8.name());
            return StandardCharsets.UTF_8;
        }
        return Charset.forName(encoding);
    }

    private String format(List<String> value) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : value) {
            if (!first) {
                sb.append(", ");
                first = false;
            } else {
                first = false;
            }
            sb.append(s);
        }
        return sb.toString();
    }
}

