/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.cxf.support;

import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.CatalogWSDLLocator;
import org.apache.cxf.common.WSDLConstants;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.ResourceManagerWSDLLocator;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.mule.runtime.module.cxf.support.WSDLQueryHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ProxyWSDLQueryHandler
extends WSDLQueryHandler {
    public static final String XSD_PARAMETER_NAME = "?xsd=";
    private final String port;

    public ProxyWSDLQueryHandler(Bus b, String port) {
        super(b);
        this.port = port;
    }

    @Override
    protected void rewriteOperationAddress(EndpointInfo ei, Document doc, String base) {
        List serviceList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://schemas.xmlsoap.org/wsdl/", (String)"service");
        for (Element serviceEl : serviceList) {
            String serviceName = serviceEl.getAttribute("name");
            if (!serviceName.equals(ei.getService().getName().getLocalPart())) continue;
            List elementList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://schemas.xmlsoap.org/wsdl/", (String)"port");
            for (Element el : elementList) {
                if (!this.rewritePortAddress(el)) continue;
                List<Element> addresses = this.findAddresses(el, "http://schemas.xmlsoap.org/wsdl/soap/");
                if (addresses.isEmpty()) {
                    addresses = this.findAddresses(el, "http://schemas.xmlsoap.org/wsdl/soap12/");
                }
                if (addresses.isEmpty()) {
                    addresses = this.findAddresses(el, WSDLConstants.QNAME_XMLHTTP_BINDING_ADDRESS.getNamespaceURI());
                }
                if (addresses.isEmpty()) continue;
                Element address = addresses.iterator().next();
                address.setAttribute("location", base);
            }
        }
    }

    @Override
    protected Definition getDefinition(EndpointInfo endpointInfo) throws WSDLException {
        String wsdlLocation;
        WSDLManager wsdlManager = (WSDLManager)this.bus.getExtension(WSDLManager.class);
        if (wsdlManager != null && (wsdlLocation = (String)endpointInfo.getService().getProperty("WSDL_LOCATION", String.class)) != null) {
            return this.loadDefinition(wsdlManager, wsdlLocation);
        }
        return new ServiceWSDLBuilder(this.bus, new ServiceInfo[]{endpointInfo.getService()}).build();
    }

    private Definition loadDefinition(WSDLManager wsdlManager, String url) throws WSDLException {
        Definition def;
        WSDLReader reader = wsdlManager.getWSDLFactory().newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        reader.setExtensionRegistry(wsdlManager.getExtensionRegistry());
        CatalogWSDLLocator catLocator = new CatalogWSDLLocator(url, this.bus);
        ResourceManagerWSDLLocator wsdlLocator = new ResourceManagerWSDLLocator(url, (WSDLLocator)catLocator, this.bus);
        InputSource src = wsdlLocator.getBaseInputSource();
        if (src.getByteStream() != null || src.getCharacterStream() != null) {
            Document doc;
            XMLStreamReader xmlReader = null;
            try {
                xmlReader = StaxUtils.createXMLStreamReader((InputSource)src);
                doc = StaxUtils.read((XMLStreamReader)xmlReader, (boolean)true);
                if (src.getSystemId() != null) {
                    try {
                        doc.setDocumentURI(new String(src.getSystemId()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                throw new WSDLException("PARSER_ERROR", e.getMessage(), (Throwable)e);
            }
            finally {
                StaxUtils.close((XMLStreamReader)xmlReader);
            }
            def = reader.readWSDL((WSDLLocator)wsdlLocator, doc.getDocumentElement());
        } else {
            def = reader.readWSDL((WSDLLocator)wsdlLocator);
        }
        return def;
    }

    private List<Element> findAddresses(Element port, String namespaceUri) {
        return DOMUtils.findAllElementsByTagNameNS((Element)port, (String)namespaceUri, (String)"address");
    }

    private boolean rewritePortAddress(Element el) {
        return this.port == null || el.getAttribute("name").equals(this.port);
    }

    @Override
    protected void checkSchemaUrl(Map<String, SchemaReference> doneSchemas, String start, String decodedStart, SchemaReference imp) throws MalformedURLException {
        super.checkSchemaUrl(doneSchemas, start, decodedStart, imp);
        doneSchemas.put(decodedStart, imp);
        String xsdParameterValue = this.getXsdParameterValue(decodedStart);
        if (xsdParameterValue != null) {
            doneSchemas.put(xsdParameterValue, imp);
        }
    }

    @Override
    protected String rewriteSchemaLocation(String base, String schemaLocation) {
        String xsdParameterValue = this.getXsdParameterValue(schemaLocation);
        if (xsdParameterValue != null) {
            schemaLocation = xsdParameterValue;
        }
        return super.rewriteSchemaLocation(base, schemaLocation);
    }

    private String getXsdParameterValue(String schemaLocation) {
        int position = schemaLocation.indexOf(XSD_PARAMETER_NAME);
        if (position > -1) {
            return schemaLocation.substring(position + XSD_PARAMETER_NAME.length());
        }
        return null;
    }
}

