/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.cxf.support;

import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.wsdl.extensions.SoapBody;
import org.apache.cxf.databinding.stax.StaxDataBindingInterceptor;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.URIMappingInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;

public class ProxyRPCInInterceptor
extends AbstractInDatabindingInterceptor {
    public ProxyRPCInInterceptor() {
        super("unmarshal");
        this.addAfter(URIMappingInterceptor.class.getName());
        this.addBefore(StaxDataBindingInterceptor.class.getName());
    }

    private BindingOperationInfo getOperation(Message message, QName opName) {
        BindingOperationInfo bop = ServiceModelUtil.getOperation((Exchange)message.getExchange(), (QName)opName);
        if (bop == null) {
            Endpoint ep = (Endpoint)message.getExchange().get(Endpoint.class);
            if (ep == null) {
                return null;
            }
            BindingInfo service = ep.getEndpointInfo().getBinding();
            boolean output = !this.isRequestor(message);
            for (BindingOperationInfo info : service.getOperations()) {
                SoapBody body;
                if (!info.getName().getLocalPart().equals(opName.getLocalPart()) || (body = output ? (SoapBody)info.getOutput().getExtensor(SoapBody.class) : (SoapBody)info.getInput().getExtensor(SoapBody.class)) == null || !opName.getNamespaceURI().equals(body.getNamespaceURI())) continue;
                return info;
            }
        }
        return bop;
    }

    public void handleMessage(Message message) throws Fault {
        DepthXMLStreamReader xmlReader = this.getXMLStreamReader(message);
        if (!StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader)) {
            message.setContent(Exception.class, (Object)new RuntimeException("There must be a method name element."));
        }
        String opName = xmlReader.getLocalName();
        if (this.isRequestor(message) && opName.endsWith("Response")) {
            opName = opName.substring(0, opName.length() - 8);
        }
        BindingOperationInfo operation = this.getOperation(message, new QName(xmlReader.getNamespaceURI(), opName));
        message.getExchange().put(BindingOperationInfo.class, (Object)operation);
    }
}

