/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.cxf.config;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.FlowConstructAware;
import org.mule.runtime.core.api.processor.InterceptingMessageProcessor;
import org.mule.runtime.core.api.processor.MessageProcessorBuilder;
import org.mule.runtime.core.api.processor.MessageProcessorContainer;
import org.mule.runtime.core.api.processor.MessageProcessorPathElement;
import org.mule.runtime.core.api.processor.Processor;

public class FlowConfiguringMessageProcessor
implements FlowConstructAware,
Lifecycle,
InterceptingMessageProcessor,
MessageProcessorContainer {
    private MessageProcessorBuilder builder;
    private Processor messageProcessor;
    private Processor listener;

    public FlowConfiguringMessageProcessor(MessageProcessorBuilder builder) {
        this.builder = builder;
    }

    public void setListener(Processor listener) {
        this.listener = listener;
    }

    public Event process(Event event) throws MuleException {
        return this.messageProcessor.process(event);
    }

    public void start() throws MuleException {
        if (this.messageProcessor instanceof Startable) {
            ((Startable)this.messageProcessor).start();
        }
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        if (this.builder instanceof FlowConstructAware) {
            ((FlowConstructAware)this.builder).setFlowConstruct(flowConstruct);
        }
    }

    public void dispose() {
        if (this.messageProcessor instanceof Disposable) {
            ((Disposable)this.messageProcessor).dispose();
        }
    }

    public void stop() throws MuleException {
        if (this.messageProcessor instanceof Stoppable) {
            ((Stoppable)this.messageProcessor).stop();
        }
    }

    public void initialise() throws InitialisationException {
        if (this.builder instanceof Initialisable) {
            ((Initialisable)this.builder).initialise();
        }
        try {
            this.messageProcessor = this.builder.build();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        if (this.messageProcessor instanceof Initialisable) {
            ((Initialisable)this.messageProcessor).initialise();
        }
        if (this.messageProcessor instanceof InterceptingMessageProcessor && this.listener != null) {
            ((InterceptingMessageProcessor)this.messageProcessor).setListener(this.listener);
        }
    }

    public Processor getWrappedMessageProcessor() {
        return this.messageProcessor;
    }

    public MessageProcessorBuilder getMessageProcessorBuilder() {
        return this.builder;
    }

    public void addMessageProcessorPathElements(MessageProcessorPathElement pathElement) {
        pathElement = pathElement.addChild(this.getWrappedMessageProcessor());
        if (this.getWrappedMessageProcessor() instanceof MessageProcessorContainer) {
            ((MessageProcessorContainer)this.getWrappedMessageProcessor()).addMessageProcessorPathElements(pathElement.addChild(this.getWrappedMessageProcessor()));
        }
    }
}

