/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.cxf.builder;

import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.interceptor.CheckFaultInterceptor;
import org.apache.cxf.binding.soap.interceptor.Soap11FaultInInterceptor;
import org.apache.cxf.binding.soap.interceptor.Soap12FaultInInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapOutInterceptor;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.stax.StaxDataBinding;
import org.apache.cxf.databinding.stax.StaxDataBindingFeature;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.interceptor.WrappedOutInterceptor;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.lifecycle.CreateException;
import org.mule.runtime.module.cxf.CxfOutboundMessageProcessor;
import org.mule.runtime.module.cxf.builder.AbstractOutboundMessageProcessorBuilder;
import org.mule.runtime.module.cxf.support.CopyAttachmentInInterceptor;
import org.mule.runtime.module.cxf.support.CopyAttachmentOutInterceptor;
import org.mule.runtime.module.cxf.support.CxfUtils;
import org.mule.runtime.module.cxf.support.OutputPayloadInterceptor;
import org.mule.runtime.module.cxf.support.ProxyService;
import org.mule.runtime.module.cxf.support.ResetStaxInterceptor;
import org.mule.runtime.module.cxf.support.ReversibleStaxInInterceptor;
import org.mule.runtime.module.cxf.support.StreamClosingInterceptor;
import org.mule.runtime.module.cxf.transport.MuleUniversalConduit;

public class ProxyClientMessageProcessorBuilder
extends AbstractOutboundMessageProcessorBuilder {
    private String payload;

    @Override
    protected void configureClient(Client client) {
        MuleUniversalConduit conduit = (MuleUniversalConduit)client.getConduit();
        client.getInInterceptors().add(new CopyAttachmentInInterceptor());
        client.getInInterceptors().add(new StreamClosingInterceptor());
        client.getOutInterceptors().add(new OutputPayloadInterceptor(this.muleContext.getTransformationService()));
        client.getOutInterceptors().add(new CopyAttachmentOutInterceptor());
        conduit.setCloseInput(false);
    }

    public boolean isProxyEnvelope() {
        return "envelope".equals(this.payload);
    }

    @Override
    protected void configureMessageProcessor(CxfOutboundMessageProcessor processor) {
        processor.setProxy(true);
    }

    @Override
    protected Client createClient() throws CreateException, Exception {
        ClientFactoryBean cpf = new ClientFactoryBean();
        cpf.setServiceClass(ProxyService.class);
        cpf.setDataBinding((DataBinding)new StaxDataBinding());
        cpf.getFeatures().add(new StaxDataBindingFeature());
        cpf.setAddress(this.getAddress());
        cpf.setBus(this.getBus());
        cpf.setProperties(this.properties);
        if (this.soapVersion != null) {
            cpf.setBindingId(CxfUtils.getBindingIdForSoapVersion(this.soapVersion));
        }
        if (this.wsdlLocation != null) {
            cpf.setWsdlURL(this.wsdlLocation);
        }
        Client client = cpf.create();
        Binding binding = client.getEndpoint().getBinding();
        CxfUtils.removeInterceptor(binding.getOutInterceptors(), WrappedOutInterceptor.class.getName());
        CxfUtils.removeInterceptor(binding.getInInterceptors(), Soap11FaultInInterceptor.class.getName());
        CxfUtils.removeInterceptor(binding.getInInterceptors(), Soap12FaultInInterceptor.class.getName());
        CxfUtils.removeInterceptor(binding.getInInterceptors(), CheckFaultInterceptor.class.getName());
        if (this.isProxyEnvelope()) {
            CxfUtils.removeInterceptor(binding.getOutInterceptors(), SoapOutInterceptor.class.getName());
            client.getInInterceptors().add(new ReversibleStaxInInterceptor());
            client.getInInterceptors().add(new ResetStaxInterceptor());
        }
        return client;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    @Override
    protected MediaType getMimeType() {
        return MediaType.XML;
    }
}

