/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.cxf.builder;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.WebEndpoint;
import javax.xml.ws.WebServiceClient;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsClientFactoryBean;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.URIResolver;
import org.mule.runtime.core.api.lifecycle.CreateException;
import org.mule.runtime.module.cxf.CxfOutboundMessageProcessor;
import org.mule.runtime.module.cxf.builder.AbstractClientMessageProcessorBuilder;
import org.mule.runtime.module.cxf.i18n.CxfMessages;
import org.mule.runtime.module.cxf.support.CxfUtils;

public class JaxWsClientMessageProcessorBuilder
extends AbstractClientMessageProcessorBuilder {
    protected BindingProvider clientProxy;
    protected String clientClass;
    protected String port;

    @Override
    protected Client createClient() throws CreateException, Exception {
        if (this.clientClass != null && this.serviceClass != null) {
            throw new CreateException(CxfMessages.onlyServiceOrClientClassIsValid(), (Object)this);
        }
        if (this.clientClass != null) {
            return this.createClientFromJaxWsProxy();
        }
        return this.createClientFromFactoryBean();
    }

    private Client createClientFromFactoryBean() {
        JaxWsClientFactoryBean cpf = new JaxWsClientFactoryBean();
        cpf.setServiceClass(this.serviceClass);
        if (this.databinding == null) {
            cpf.setDataBinding(this.databinding);
        }
        cpf.setAddress(this.getAddress());
        cpf.setBus(this.getBus());
        cpf.setProperties(this.properties);
        if (this.soapVersion != null) {
            cpf.setBindingId(CxfUtils.getBindingIdForSoapVersion(this.soapVersion));
        }
        if (this.wsdlLocation != null) {
            cpf.setWsdlURL(this.wsdlLocation);
        }
        return cpf.create();
    }

    private Client createClientFromJaxWsProxy() throws ClassNotFoundException, NoSuchMethodException, IOException, CreateException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class clientCls = ClassLoaderUtils.loadClass((String)this.clientClass, this.getClass());
        Service s = null;
        if (this.wsdlLocation != null) {
            Constructor cons = clientCls.getConstructor(URL.class, QName.class);
            ResourceManager rr = (ResourceManager)this.getBus().getExtension(ResourceManager.class);
            URL url = (URL)rr.resolveResource(this.wsdlLocation, URL.class);
            if (url == null) {
                URIResolver res = new URIResolver(this.wsdlLocation);
                if (!res.isResolved()) {
                    throw new CreateException(CxfMessages.wsdlNotFound(this.wsdlLocation), (Object)this);
                }
                url = res.getURL();
            }
            WebServiceClient clientAnn = clientCls.getAnnotation(WebServiceClient.class);
            QName svcName = new QName(clientAnn.targetNamespace(), clientAnn.name());
            s = (Service)cons.newInstance(url, svcName);
        } else {
            s = (Service)clientCls.newInstance();
        }
        if (this.port == null) {
            throw new CreateException(CxfMessages.mustSpecifyPort(), (Object)this);
        }
        this.clientProxy = null;
        for (Method m : clientCls.getMethods()) {
            WebEndpoint we = m.getAnnotation(WebEndpoint.class);
            if (we == null || !we.name().equals(this.port) || m.getParameterTypes().length != 0) continue;
            this.clientProxy = (BindingProvider)m.invoke((Object)s, new Object[0]);
            break;
        }
        if (this.clientProxy == null) {
            throw new CreateException(CxfMessages.portNotFound(this.port), (Object)this);
        }
        return ClientProxy.getClient((Object)this.clientProxy);
    }

    @Override
    protected void configureMessageProcessor(CxfOutboundMessageProcessor processor) {
        super.configureMessageProcessor(processor);
        processor.setClientProxy(this.clientProxy);
    }

    public String getClientClass() {
        return this.clientClass;
    }

    public void setClientClass(String clientClass) {
        this.clientClass = clientClass;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }
}

