/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.cxf;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxInEndingInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.MultiPartPayload;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.connector.DispatchException;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.api.processor.CloneableMessageProcessor;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.exception.WrapperErrorMessageAwareException;
import org.mule.runtime.core.message.PartAttributes;
import org.mule.runtime.core.processor.AbstractInterceptingMessageProcessor;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.module.cxf.CxfPayloadToArguments;
import org.mule.runtime.module.cxf.i18n.CxfMessages;
import org.mule.runtime.module.cxf.security.WebServiceSecurityException;

public class CxfOutboundMessageProcessor
extends AbstractInterceptingMessageProcessor
implements CloneableMessageProcessor {
    private CxfPayloadToArguments payloadToArguments = CxfPayloadToArguments.NULL_PAYLOAD_AS_PARAMETER;
    private Client client;
    private boolean proxy;
    private String operation;
    private BindingProvider clientProxy;
    private String decoupledEndpoint;
    private MediaType mimeType;

    public CxfOutboundMessageProcessor(Client client) {
        this.client = client;
    }

    protected void cleanup() {
        Map requestContext = this.client.getRequestContext();
        requestContext.clear();
        Map responseContext = this.client.getResponseContext();
        responseContext.clear();
    }

    protected Object[] getArgs(Event event) throws TransformerException {
        Object payload = event.getMessage().getPayload().getValue();
        if (this.proxy) {
            return new Object[]{event.getMessage()};
        }
        Object[] args = this.payloadToArguments.payloadToArrayOfArguments(payload);
        ArrayList<DataHandler> attachments = new ArrayList<DataHandler>();
        for (String inboundAttachmentName : event.getMessage().getInboundAttachmentNames()) {
            attachments.add(event.getMessage().getInboundAttachment(inboundAttachmentName));
        }
        try {
            if (event.getMessage().getPayload().getValue() instanceof MultiPartPayload) {
                for (Message part : ((MultiPartPayload)event.getMessage().getPayload().getValue()).getParts()) {
                    attachments.add(IOUtils.toDataHandler((String)((PartAttributes)part.getAttributes()).getName(), (Object)part.getPayload().getValue(), (MediaType)part.getPayload().getDataType().getMediaType()));
                }
            }
        }
        catch (IOException e) {
            throw new TransformerException(I18nMessageFactory.createStaticMessage((String)"Exception processing attachments."), (Throwable)e);
        }
        if (!attachments.isEmpty()) {
            ArrayList<Object> temp = new ArrayList<Object>(Arrays.asList(args));
            temp.add(attachments.toArray(new DataHandler[attachments.size()]));
            args = temp.toArray();
        }
        if (args.length == 0) {
            return null;
        }
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event process(Event event) throws MuleException {
        try {
            Event res = !this.isClientProxyAvailable() ? this.doSendWithClient(event) : this.doSendWithProxy(event);
            Event event2 = res;
            return event2;
        }
        finally {
            this.cleanup();
        }
    }

    private MuleException wrapException(Event event, Throwable ex) {
        if (ex instanceof MessagingException) {
            return (MessagingException)ex;
        }
        if (ex instanceof Fault) {
            Fault fault = (Fault)ex;
            if (fault.getCause() instanceof MuleException) {
                MuleException muleException = (MuleException)fault.getCause();
                return muleException;
            }
            DispatchException dispatchException = new DispatchException(I18nMessageFactory.createStaticMessage((String)fault.getMessage()), (Processor)this, (Throwable)fault);
            return new WrapperErrorMessageAwareException((Message)event.getMessage(), (Throwable)dispatchException);
        }
        DispatchException dispatchException = new DispatchException(I18nMessageFactory.createStaticMessage((String)ExceptionHelper.getRootException((Throwable)ex).getMessage()), (Processor)this, ex);
        return new WrapperErrorMessageAwareException((Message)event.getMessage(), (Throwable)dispatchException);
    }

    private MessagingException wrapToMessagingException(Event event, Throwable ex) {
        if (ex instanceof MessagingException) {
            return (MessagingException)ex;
        }
        if (ex instanceof Fault) {
            Fault fault = (Fault)ex;
            if (fault.getCause() instanceof MuleException) {
                MuleException muleException = (MuleException)fault.getCause();
                return new MessagingException(event, (Throwable)muleException, (Processor)this);
            }
            DispatchException dispatchException = new DispatchException(I18nMessageFactory.createStaticMessage((String)fault.getMessage()), (Processor)this, (Throwable)fault);
            return new MessagingException(event, (Throwable)dispatchException);
        }
        DispatchException dispatchException = new DispatchException(I18nMessageFactory.createStaticMessage((String)ExceptionHelper.getRootException((Throwable)ex).getMessage()), (Processor)this, ex);
        return new MessagingException(event, (Throwable)dispatchException);
    }

    public Event processNext(Event event) throws MuleException {
        return super.processNext(event);
    }

    protected Event doSendWithProxy(Event event) throws MuleException {
        try {
            Object response;
            Method method = this.getMethod(event);
            Map<String, Object> props = this.getInovcationProperties(event);
            Holder responseHolder = new Holder();
            props.put("holder", responseHolder);
            String soapAction = (String)((Object)event.getMessage().getOutboundProperty("soapAction"));
            if (soapAction != null) {
                props.put("SOAPAction", soapAction);
            }
            this.clientProxy.getRequestContext().putAll(props);
            Object[] args = this.getArgs(event);
            try {
                response = method.invoke((Object)this.clientProxy, args);
            }
            catch (InvocationTargetException e) {
                Throwable ex = e.getTargetException();
                if (ex != null && ex.getMessage().contains("Security")) {
                    throw new WebServiceSecurityException(event, e, this.muleContext.getSecurityManager());
                }
                throw e;
            }
            Object[] objResponse = this.addHoldersToResponse(response, args);
            Event muleRes = (Event)responseHolder.value;
            return this.buildResponseMessage(event, muleRes, objResponse);
        }
        catch (Exception e) {
            throw this.wrapException(event, e);
        }
    }

    protected Event doSendWithClient(Event event) throws MuleException {
        Object[] arr;
        BindingOperationInfo bop;
        try {
            bop = this.getOperation(event);
        }
        catch (Exception e) {
            throw this.wrapException(event, e);
        }
        Map<String, Object> props = this.getInovcationProperties(event);
        Holder responseHolder = new Holder();
        props.put("holder", responseHolder);
        HashMap<String, Map<String, Object>> ctx = new HashMap<String, Map<String, Object>>();
        ctx.put("RequestContext", props);
        ctx.put("ResponseContext", props);
        for (Object element : arr = event.getMessage().getOutboundPropertyNames().toArray()) {
            String head = (String)element;
            if (head == null || head.startsWith("MULE")) continue;
            props.put((String)element, event.getMessage().getOutboundProperty((String)element));
        }
        ExchangeImpl exchange = new ExchangeImpl();
        exchange.put(StaxInEndingInterceptor.STAX_IN_NOCLOSE, (Object)Boolean.TRUE);
        try {
            Object[] response = this.client.invoke(bop, this.getArgs(event), ctx, (Exchange)exchange);
            return this.buildResponseMessage(event, (Event)exchange.get((Object)"mule.event"), response);
        }
        catch (Exception e) {
            throw this.wrapException((Event)exchange.get((Object)"mule.event"), e);
        }
    }

    public Method getMethod(Event event) throws Exception {
        Method method = null;
        String opName = (String)((Object)event.getMessage().getOutboundProperty("operation"));
        if (opName != null) {
            method = this.getMethodFromOperation(opName);
        }
        if (method == null && (opName = this.operation) != null) {
            method = this.getMethodFromOperation(opName);
        }
        if (method == null) {
            throw new MessagingException(CxfMessages.noOperationWasFoundOrSpecified(), event, (Processor)this);
        }
        return method;
    }

    protected BindingOperationInfo getOperation(String opName) throws Exception {
        Endpoint ep = this.client.getEndpoint();
        BindingOperationInfo bop = this.getBindingOperationFromEndpoint(ep, opName);
        if (bop == null && (bop = this.tryToGetTheOperationInDotNetNamingConvention(ep, opName)) == null) {
            throw new Exception("No such operation: " + opName);
        }
        if (bop.isUnwrappedCapable()) {
            bop = bop.getUnwrappedOperation();
        }
        return bop;
    }

    protected BindingOperationInfo tryToGetTheOperationInDotNetNamingConvention(Endpoint ep, String opName) {
        String capitalizedOpName = opName.substring(0, 1).toUpperCase() + opName.substring(1);
        return this.getBindingOperationFromEndpoint(ep, capitalizedOpName);
    }

    protected BindingOperationInfo getBindingOperationFromEndpoint(Endpoint ep, String operationName) {
        QName q = new QName(ep.getService().getName().getNamespaceURI(), operationName);
        BindingOperationInfo bop = ep.getBinding().getBindingInfo().getOperation(q);
        return bop;
    }

    private Method getMethodFromOperation(String op) throws Exception {
        BindingOperationInfo bop = this.getOperation(op);
        MethodDispatcher md = (MethodDispatcher)this.client.getEndpoint().getService().get((Object)MethodDispatcher.class.getName());
        return md.getMethod(bop);
    }

    protected String getMethodOrOperationName(Event event) throws DispatchException {
        Object muleMethodProperty;
        String method = (String)Event.getVariableValueOrNull((String)"operation", (Event)event);
        if (method == null && (muleMethodProperty = Event.getVariableValueOrNull((String)"method", (Event)event)) != null) {
            method = muleMethodProperty instanceof Method ? ((Method)muleMethodProperty).getName() : muleMethodProperty.toString();
        }
        if (method == null) {
            method = this.operation;
        }
        if (method == null && this.proxy) {
            return "invoke";
        }
        return method;
    }

    public BindingOperationInfo getOperation(Event event) throws Exception {
        String opName = this.getMethodOrOperationName(event);
        if (opName == null) {
            opName = this.operation;
        }
        return this.getOperation(opName);
    }

    private Map<String, Object> getInovcationProperties(Event event) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("mule.event", event);
        props.put("cxf_outbound_message_processor", (Object)this);
        if (this.decoupledEndpoint != null) {
            props.put("org.apache.cxf.ws.addressing.replyto", this.decoupledEndpoint);
        }
        return props;
    }

    protected Event buildResponseMessage(Event request, Event transportResponse, Object[] response) {
        if (transportResponse == null) {
            return null;
        }
        Object payload = response == null || response.length == 0 ? null : (response.length == 1 ? response[0] : response);
        InternalMessage.Builder builder = InternalMessage.builder((InternalMessage)transportResponse.getMessage());
        Serializable httpStatusCode = transportResponse.getMessage().getInboundProperty("http.status");
        if (this.isProxy() && httpStatusCode != null) {
            builder.addOutboundProperty("http.status", httpStatusCode);
        }
        builder.payload(payload).mediaType(this.getMimeType());
        return Event.builder((Event)transportResponse).message(builder.build()).build();
    }

    protected Object[] addHoldersToResponse(Object response, Object[] args) {
        ArrayList<Object> responseWithHolders = new ArrayList<Object>();
        responseWithHolders.add(response);
        if (args != null) {
            for (Object arg : args) {
                if (!(arg instanceof Holder)) continue;
                responseWithHolders.add(arg);
            }
        }
        return responseWithHolders.toArray();
    }

    public void setPayloadToArguments(CxfPayloadToArguments payloadToArguments) {
        this.payloadToArguments = payloadToArguments;
    }

    protected boolean isClientProxyAvailable() {
        return this.clientProxy != null;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public void setProxy(boolean proxy) {
        this.proxy = proxy;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void setClientProxy(BindingProvider clientProxy) {
        this.clientProxy = clientProxy;
    }

    public CxfPayloadToArguments getPayloadToArguments() {
        return this.payloadToArguments;
    }

    public Client getClient() {
        return this.client;
    }

    public void setDecoupledEndpoint(String decoupledEndpoint) {
        this.decoupledEndpoint = decoupledEndpoint;
    }

    public Processor clone() {
        CxfOutboundMessageProcessor clone = new CxfOutboundMessageProcessor(this.client);
        clone.payloadToArguments = this.payloadToArguments;
        clone.proxy = this.proxy;
        clone.operation = this.operation;
        clone.clientProxy = this.clientProxy;
        clone.decoupledEndpoint = this.decoupledEndpoint;
        return clone;
    }

    public MediaType getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(MediaType mimeType) {
        this.mimeType = mimeType;
    }
}

