/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import javax.script.ScriptException;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.VoidMuleEvent;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.execution.ExecutionCallback;
import org.mule.api.transport.PropertyScope;
import org.mule.component.ComponentException;
import org.mule.config.ExceptionHelper;
import org.mule.execution.ErrorHandlingExecutionTemplate;
import org.mule.module.cxf.CxfInboundMessageProcessor;
import org.mule.transport.NullPayload;

public class MuleInvoker
implements Invoker {
    private final CxfInboundMessageProcessor cxfMmessageProcessor;
    private Class<?> targetClass;

    public MuleInvoker(CxfInboundMessageProcessor cxfMmessageProcessor, Class<?> targetClass) {
        this.cxfMmessageProcessor = cxfMmessageProcessor;
        this.targetClass = targetClass;
    }

    public Object invoke(Exchange exchange, Object o) {
        final MuleEvent event = (MuleEvent)exchange.get((Object)"mule.event");
        MuleEvent responseEvent = null;
        if (PropertyUtils.isTrue((Object)exchange.remove((Object)"mule.nonBlockingResponse"))) {
            responseEvent = event;
        } else {
            try {
                MuleMessage reqMsg = event.getMessage();
                reqMsg.setPayload(this.extractPayload(exchange.getInMessage()));
                BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
                Service svc = (Service)exchange.get(Service.class);
                if (!this.cxfMmessageProcessor.isProxy()) {
                    MethodDispatcher md = (MethodDispatcher)svc.get((Object)MethodDispatcher.class.getName());
                    Method m = md.getMethod(bop);
                    if (this.targetClass != null) {
                        m = MuleInvoker.matchMethod(m, this.targetClass);
                    }
                    reqMsg.setProperty("method", (Object)m, PropertyScope.INVOCATION);
                }
                if (bop != null) {
                    reqMsg.setProperty("cxf_operation", (Object)bop.getOperationInfo().getName(), PropertyScope.INVOCATION);
                    reqMsg.setProperty("cxf_service", (Object)svc.getName(), PropertyScope.INVOCATION);
                }
                ErrorHandlingExecutionTemplate errorHandlingExecutionTemplate = ErrorHandlingExecutionTemplate.createErrorHandlingExecutionTemplate((MuleContext)event.getMuleContext(), (MessagingExceptionHandler)event.getFlowConstruct().getExceptionListener());
                responseEvent = errorHandlingExecutionTemplate.execute((ExecutionCallback)new ExecutionCallback<MuleEvent>(){

                    public MuleEvent process() throws Exception {
                        return MuleInvoker.this.cxfMmessageProcessor.processNext(event);
                    }
                });
            }
            catch (MuleException e) {
                exchange.put((Object)"mule.event", (Object)event);
                Throwable cause = e;
                if (Boolean.valueOf((String)event.getMessage().getInvocationProperty("unwrapMuleExceptions")).booleanValue()) {
                    cause = ExceptionHelper.getNonMuleException((Throwable)e);
                    if (cause instanceof ScriptException && cause.getCause() != null) {
                        cause = cause.getCause();
                    }
                } else if (e instanceof ComponentException) {
                    cause = e.getCause();
                }
                throw new Fault(cause);
            }
            catch (Exception e) {
                exchange.put((Object)"mule.event", (Object)event);
                throw new Fault((Throwable)e);
            }
            if (!event.getExchangePattern().hasResponse()) {
                responseEvent = null;
            }
            if (responseEvent instanceof NonBlockingVoidMuleEvent) {
                exchange.put((Object)"org.apache.cxf.suspended.invocation", (Object)true);
                exchange.put((Object)"mule.event", (Object)responseEvent);
                return null;
            }
        }
        if (responseEvent != null && !VoidMuleEvent.getInstance().equals(responseEvent)) {
            exchange.put((Object)"mule.event", (Object)responseEvent);
            MuleMessage resMessage = responseEvent.getMessage();
            if (resMessage.getExceptionPayload() != null) {
                Throwable cause = resMessage.getExceptionPayload().getException();
                if (cause instanceof ComponentException) {
                    cause = cause.getCause();
                }
                exchange.getInMessage().put(FaultMode.class, (Object)FaultMode.UNCHECKED_APPLICATION_FAULT);
                if (cause instanceof Fault) {
                    throw (Fault)cause;
                }
                throw new Fault(cause);
            }
            if (resMessage.getPayload() instanceof NullPayload) {
                return new MessageContentsList(new Object[]{null});
            }
            if (this.cxfMmessageProcessor.isProxy()) {
                resMessage.getPayload();
                return new Object[]{resMessage};
            }
            return new Object[]{resMessage.getPayload()};
        }
        exchange.getInMessage().getInterceptorChain().abort();
        if (exchange.getOutMessage() != null) {
            exchange.getOutMessage().getInterceptorChain().abort();
        }
        exchange.put((Object)"mule.event", null);
        return null;
    }

    protected Object extractPayload(Message cxfMessage) {
        List list = CastUtils.cast((List)((List)cxfMessage.getContent(List.class)));
        if (list == null) {
            Object object = cxfMessage.getContent(Object.class);
            if (object != null) {
                return object;
            }
            return new Object[0];
        }
        if (list.size() == 1 && list.get(0) != null) {
            return list.get(0);
        }
        return list.toArray();
    }

    private static Method matchMethod(Method methodToMatch, Class<?> targetClass) {
        Class<?>[] interfaces = targetClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Method m = MuleInvoker.getMostSpecificMethod(methodToMatch, interfaces[i]);
            if (methodToMatch.equals(m)) continue;
            return m;
        }
        return methodToMatch;
    }

    public static boolean isJdkDynamicProxy(Object object) {
        return object != null && Proxy.isProxyClass(object.getClass());
    }

    public static Method getMostSpecificMethod(Method method, Class<?> targetClass) {
        if (method != null && targetClass != null) {
            try {
                method = targetClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return method;
    }
}

