/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.support;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.mule.module.cxf.i18n.CxfMessages;
import org.mule.module.cxf.support.ComponentNotFoundRuntimeException;
import org.mule.module.cxf.support.ProxyService;
import org.mule.module.cxf.support.ProxyServiceConfiguration;

public class ProxyServiceFactoryBean
extends ReflectionServiceFactoryBean {
    private static final Logger LOG = LogUtils.getLogger(ProxyServiceFactoryBean.class);

    public ProxyServiceFactoryBean() {
        this.getServiceConfigurations().add(0, new ProxyServiceConfiguration());
        ArrayList<String> ignoredClasses = new ArrayList<String>();
        ignoredClasses.add("java.lang.Object");
        ignoredClasses.add("java.lang.Throwable");
        ignoredClasses.add("org.omg.CORBA_2_3.portable.ObjectImpl");
        ignoredClasses.add("org.omg.CORBA.portable.ObjectImpl");
        ignoredClasses.add("javax.ejb.EJBObject");
        ignoredClasses.add("javax.rmi.CORBA.Stub");
        this.setIgnoredClasses(ignoredClasses);
    }

    protected void initializeWSDLOperations() {
        if (this.getServiceClass().isAssignableFrom(ProxyService.class)) {
            this.initializeWSDLOperationsForProvider();
        } else {
            super.initializeWSDLOperations();
        }
    }

    protected void initializeWSDLOperationsForProvider() {
        Class<Source> c = Source.class;
        if (this.getEndpointInfo() == null && this.isFromWsdl()) {
            ArrayList<QName> enames = new ArrayList<QName>();
            for (ServiceInfo si : this.getService().getServiceInfos()) {
                for (EndpointInfo ep : si.getEndpoints()) {
                    enames.add(ep.getName());
                }
            }
            LOG.log(Level.WARNING, "COULD_NOT_FIND_ENDPOINT", (Throwable)((Object)new ComponentNotFoundRuntimeException(CxfMessages.couldNotFindEndpoint(this.getEndpointName(), enames))));
        }
        try {
            Method invoke = this.getServiceClass().getMethod("invoke", c);
            for (ServiceInfo si : this.getService().getServiceInfos()) {
                for (OperationInfo o : si.getInterface().getOperations()) {
                    this.getMethodDispatcher().bind(o, new Method[]{invoke});
                }
            }
        }
        catch (SecurityException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
    }
}

