/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.stream.impl.internal;

import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.collections.internal.iterator.ZipIterator;
import net.sf.staccatocommons.collections.iterable.Iterables;
import net.sf.staccatocommons.collections.stream.AbstractStream;
import net.sf.staccatocommons.collections.stream.Stream;
import net.sf.staccatocommons.defs.function.Function2;
import net.sf.staccatocommons.iterators.thriter.Thriter;
import net.sf.staccatocommons.iterators.thriter.Thriterator;
import net.sf.staccatocommons.iterators.thriter.Thriterators;
import net.sf.staccatocommons.restrictions.check.NonNull;

public final class ZipStream<C, A, B>
extends AbstractStream<C> {
    private final Iterable<B> iterable;
    private final Function2<A, B, C> function;
    private final Stream<A> stream;

    public ZipStream(@NonNull AbstractStream<A> abstractStream, @NonNull Iterable<B> iterable, @NonNull Function2<A, B, C> function) {
        Ensure.isNotNull((String)"var2", function);
        Ensure.isNotNull((String)"var1", iterable);
        Ensure.isNotNull((String)"var0", abstractStream);
        this.iterable = iterable;
        this.function = function;
        this.stream = abstractStream;
    }

    @Override
    public Thriterator<C> iterator() {
        return new ZipIterator<A, B, C>((Thriter)this.stream.iterator(), (Thriter)Thriterators.from(this.iterable.iterator()), this.function);
    }

    @Override
    public int size() {
        return Math.min(this.stream.size(), Iterables.size(this.iterable));
    }

    @Override
    public boolean isEmpty() {
        return this.stream.isEmpty() || Iterables.isEmpty(this.iterable);
    }
}

