/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.stream.impl.internal;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.sf.staccatocommons.collections.iterable.Iterables;
import net.sf.staccatocommons.collections.stream.AbstractStream;
import net.sf.staccatocommons.collections.stream.Stream;
import net.sf.staccatocommons.iterators.thriter.Thriterator;
import net.sf.staccatocommons.iterators.thriter.Thriterators;

public final class SortedStream<A>
extends AbstractStream<A> {
    private final Stream<A> source;
    private final Comparator<? super A> comparator;

    public SortedStream(Stream<A> source, Comparator<A> comparator) {
        this.source = source;
        this.comparator = comparator;
    }

    @Override
    public Thriterator<A> iterator() {
        return Thriterators.from(this.toList().iterator());
    }

    @Override
    public List<A> toList() {
        return Iterables.toSortedList(this.getSource(), this.comparator);
    }

    @Override
    public Set<A> toSet() {
        return Iterables.toSortedSet(this.getSource(), this.comparator);
    }

    @Override
    public A first() {
        return this.minimumBy(this.comparator);
    }

    @Override
    public A last() {
        return this.maximumBy(this.comparator);
    }

    private Stream<A> getSource() {
        return this.source;
    }
}

