/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.stream.impl;

import java.util.List;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.collections.stream.Stream;
import net.sf.staccatocommons.collections.stream.impl.CollectionStream;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.check.NotNegative;

public class ListStream<A>
extends CollectionStream<A> {
    public ListStream(@NonNull List<? extends A> iterable) {
        Ensure.isNotNull((String)"var0", iterable);
        super(iterable);
    }

    @Override
    public final A get(int n) {
        return this.getList().get(n);
    }

    @Override
    public final int indexOf(A element) {
        return this.getList().indexOf(element);
    }

    protected List<A> getList() {
        return (List)this.getCollection();
    }

    @Override
    public A last() {
        return this.get(this.size() - 1);
    }

    @Override
    public Stream<A> take(int amountOfElements) {
        return new ListStream<A>(this.getList().subList(0, this.atMost(amountOfElements)));
    }

    @Override
    public Stream<A> drop(@NotNegative int amountOfElements) {
        Ensure.that().isNotNegative("var0", amountOfElements);
        return new ListStream<A>(this.getList().subList(this.atMost(amountOfElements), this.size()));
    }
}

