/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.stream;

import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.collections.stream.Stream;
import net.sf.staccatocommons.collections.stream.impl.CharSequenceStream;
import net.sf.staccatocommons.collections.stream.impl.CollectionStream;
import net.sf.staccatocommons.collections.stream.impl.DequeStream;
import net.sf.staccatocommons.collections.stream.impl.EmptyStream;
import net.sf.staccatocommons.collections.stream.impl.IterableStream;
import net.sf.staccatocommons.collections.stream.impl.IteratorStream;
import net.sf.staccatocommons.collections.stream.impl.ListStream;
import net.sf.staccatocommons.collections.stream.impl.SingleStream;
import net.sf.staccatocommons.collections.stream.impl.internal.UndefinedStream;
import net.sf.staccatocommons.collections.stream.impl.internal.delayed.ConsStream;
import net.sf.staccatocommons.collections.stream.impl.internal.delayed.DelayedSingleStream;
import net.sf.staccatocommons.defs.Applicable;
import net.sf.staccatocommons.defs.Evaluable;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.iterators.EnumerationIterator;
import net.sf.staccatocommons.iterators.thriter.AbstractThriterator;
import net.sf.staccatocommons.iterators.thriter.NextThriterator;
import net.sf.staccatocommons.lang.predicate.Predicates;
import net.sf.staccatocommons.lang.sequence.Sequence;
import net.sf.staccatocommons.lang.sequence.StopConditions;
import net.sf.staccatocommons.lang.thunk.Thunks;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.processing.ForceRestrictions;

public class Streams {
    private Streams() {
    }

    public static <A> Stream<A> cons(Thunk<A> head, @NonNull Stream<? extends A> tail) {
        return new ConsStream<A>(head, tail);
    }

    public static <A> Stream<A> cons(A head, @NonNull Stream<? extends A> tail) {
        return new ConsStream<A>(Thunks.constant(head), tail);
    }

    public static <A> Stream<A> cons(A ... elements) {
        return Streams.from(Arrays.asList(elements));
    }

    public static <A> Stream<A> cons(Thunk<A> element) {
        return new DelayedSingleStream<A>(element);
    }

    public static <A> Stream<A> cons(A element) {
        return new SingleStream<A>(element);
    }

    public static <A> Stream<A> iterate(@NonNull A seed, @NonNull Applicable<? super A, ? extends A> generator) {
        return Streams.from((Iterable)Sequence.from(seed, generator, (Evaluable)((Evaluable)StopConditions.stopNever())));
    }

    public static <A> Stream<A> iterateUntilNull(@NonNull A seed, @NonNull Applicable<? super A, ? extends A> generator) {
        return Streams.from((Iterable)Sequence.from(seed, generator, (Evaluable)((Evaluable)Predicates.null_())));
    }

    public static <A> Stream<A> iterate(@NonNull A start, @NonNull Applicable<? super A, ? extends A> generator, @NonNull Evaluable<A> stopCondition) {
        return Streams.from((Iterable)Sequence.from(start, generator, stopCondition));
    }

    public static Stream<Integer> iterate(int start, int stop) {
        return Streams.from(Sequence.fromTo((int)start, (int)stop));
    }

    public static <A> Stream<A> repeat(final A element) {
        return Streams.from(new AbstractThriterator<A>(){

            public boolean hasNext() {
                return true;
            }

            public A next() {
                return element;
            }

            public void advanceNext() throws NoSuchElementException {
            }

            public A current() {
                return element;
            }
        });
    }

    @ForceRestrictions
    public static <A> Stream<A> repeat(final @NonNull Thunk<A> thunk) {
        Ensure.isNotNull((String)"var0", thunk);
        return Streams.from(new NextThriterator<A>(){

            public boolean hasNext() {
                return true;
            }

            public A nextImpl() {
                return thunk.value();
            }
        });
    }

    public static <A> Stream<A> from(@NonNull Iterable<? extends A> iterable) {
        return iterable instanceof Stream ? (Stream<Object>)iterable : new IterableStream<A>(iterable);
    }

    public static <A> Stream<A> from(@NonNull Iterator<? extends A> iterator) {
        return new IteratorStream<A>(iterator);
    }

    public static <A> Stream<A> from(@NonNull Enumeration<? extends A> enumeration) {
        return Streams.from(new EnumerationIterator(enumeration));
    }

    public static Stream<Character> from(@NonNull CharSequence charSequence) {
        return new CharSequenceStream(charSequence);
    }

    public static <A> Stream<A> from(@NonNull Collection<? extends A> collection) {
        return new CollectionStream<A>(collection);
    }

    public static <A> Stream<A> from(@NonNull List<? extends A> list) {
        return new ListStream<A>(list);
    }

    @NonNull
    public static <A> Stream<A> from(@NonNull Deque<? extends A> list) {
        return new DequeStream(list);
    }

    @Constant
    public static <A> Stream<A> empty() {
        return EmptyStream.empty();
    }

    @Constant
    public static <A> Stream<A> undefined() {
        return UndefinedStream.undefined();
    }

    @Constant
    public static <A> Class<Stream<A>> type() {
        return Stream.class;
    }
}

