/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.iterable.internal;

import java.util.Collection;
import java.util.Iterator;
import net.sf.staccatocommons.defs.Applicable;
import net.sf.staccatocommons.defs.Evaluable;

public class IterablesInternal {
    public static final String ITERABLE = "iterable";

    public static <T> void addAllInternal(Collection<T> collection, Iterable<? extends T> iterable) {
        for (T element : iterable) {
            collection.add(element);
        }
    }

    public static <T, C extends Collection<T>> C takeInternal(Iterable<T> iterable, int amountOfElements, C outputCollection) {
        Iterator<T> iter = iterable.iterator();
        int i = 0;
        while (i < amountOfElements && iter.hasNext()) {
            outputCollection.add(iter.next());
            ++i;
        }
        return outputCollection;
    }

    public static <T, C extends Collection<T>> C filterInternal(Iterable<T> iterable, Evaluable<? super T> predicate, C collection) {
        for (T element : iterable) {
            if (!predicate.eval(element)) continue;
            collection.add(element);
        }
        return collection;
    }

    public static <I, O, C extends Collection<O>> C collectInternal(Iterable<I> iterable, Applicable<? super I, ? extends O> function, C outputCollection) {
        for (I element : iterable) {
            outputCollection.add((Object)function.apply(element));
        }
        return outputCollection;
    }

    public static <T> boolean containsInternal(Iterable<T> iterable, T element) {
        for (T each : iterable) {
            if (!each.equals(element)) continue;
            return true;
        }
        return false;
    }
}

