/*
 * Decompiled with CFR 0.152.
 */
package ar.com.zauber.commons.mom.converter;

import ar.com.zauber.commons.mom.converter.TypeConverter;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.collections.stream.Streams;
import net.sf.staccatocommons.defs.Evaluable;
import net.sf.staccatocommons.lang.predicate.AbstractPredicate;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.processing.ForceRestrictions;

public class CompositeTypeConverter
implements TypeConverter {
    private final Iterable<TypeConverter> typeConverters;

    public CompositeTypeConverter(@NonNull Iterable<TypeConverter> typeConverters) {
        Ensure.isNotNull((String)"var0", typeConverters);
        this.typeConverters = typeConverters;
    }

    @Override
    @ForceRestrictions
    public boolean canConvert(@NonNull Class<?> sourceType, @NonNull Class<?> destinationType) {
        Ensure.isNotNull((String)"var1", destinationType);
        Ensure.isNotNull((String)"var0", sourceType);
        return Streams.from(this.typeConverters).any(this.converterCanConvert(sourceType, destinationType));
    }

    @Override
    @ForceRestrictions
    public <A> A convert(@NonNull Object value, @NonNull Class<A> destinationType) {
        Ensure.isNotNull((String)"var1", destinationType);
        Ensure.isNotNull((String)"var0", (Object)value);
        TypeConverter converter = this.findConverter(value, destinationType);
        Ensure.that((converter != null ? 1 : 0) != 0, (String)"No converter found that can convert %s to %s", (Object[])new Object[]{value, destinationType});
        return converter.convert(value, destinationType);
    }

    protected <A> TypeConverter findConverter(Object value, Class<A> destinationType) {
        return (TypeConverter)Streams.from(this.typeConverters).findOrNull(this.converterCanConvert(value.getClass(), destinationType));
    }

    private Evaluable<? super TypeConverter> converterCanConvert(final Class<?> sourceType, final Class<?> destinationType) {
        return new AbstractPredicate<TypeConverter>(){

            public boolean eval(TypeConverter arg0) {
                return arg0.canConvert(sourceType, destinationType);
            }
        };
    }
}

