/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.value;

import java.util.Comparator;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.lang.predicate.AbstractPredicate2;
import net.sf.staccatocommons.lang.value.BasicEquals;
import net.sf.staccatocommons.lang.value.CompareStateBuilder;
import net.sf.staccatocommons.lang.value.EqualsStateBuilder;
import net.sf.staccatocommons.lang.value.HashCodeStateBuilder;
import net.sf.staccatocommons.lang.value.NamedTupleToStringStyle;
import net.sf.staccatocommons.lang.value.ToStringCriteria;
import net.sf.staccatocommons.lang.value.TwoPhaseStateBuilder;
import net.sf.staccatocommons.lang.value.TwoPhaseStateBuilderState;
import net.sf.staccatocommons.restrictions.check.NonNull;
import org.apache.commons.lang.builder.ToStringStyle;

public abstract class RelevantState<A>
extends AbstractPredicate2<A, A>
implements Comparator<A> {
    private final int relevantAttributesCount;
    private final ToStringStyle toStringStyle;

    public RelevantState(int relevantAttributesCount, @NonNull ToStringStyle toStringStyle) {
        Ensure.isNotNull((String)"var1", (Object)toStringStyle);
        this.relevantAttributesCount = relevantAttributesCount;
        this.toStringStyle = toStringStyle;
    }

    public RelevantState(int relevantAttributesCount) {
        this(relevantAttributesCount, NamedTupleToStringStyle.getInstance());
    }

    public int hashCode(@NonNull A object) {
        HashCodeStateBuilder b = new HashCodeStateBuilder();
        this.collectState(object, b);
        return b.toHashCode();
    }

    public String toString(@NonNull A object) {
        ToStringCriteria b = new ToStringCriteria(object, this.toStringStyle);
        this.collectState(object, b);
        return b.toString();
    }

    public int compareTo(@NonNull A object, A other) {
        if (object == other) {
            return 0;
        }
        CompareStateBuilder b = new CompareStateBuilder(this.relevantAttributesCount);
        this.collectStateInTwoPhases(object, other, b);
        return b.toComparison();
    }

    @Override
    public int compare(A o1, A o2) {
        return this.compareTo(o1, o2);
    }

    public boolean equals(@NonNull A object, Object other) {
        BasicEquals be = BasicEquals.from(object, other);
        if (be.isEqualsDone()) {
            return be.toEquals();
        }
        EqualsStateBuilder sb = new EqualsStateBuilder(this.relevantAttributesCount);
        this.collectStateInTwoPhases(object, other, sb);
        return sb.isEquals();
    }

    public boolean eval(A arg0, A arg1) {
        if (arg0 == null) {
            return arg1 == null;
        }
        return this.equals(arg0, arg1);
    }

    private void collectStateInTwoPhases(A object, Object other, TwoPhaseStateBuilder sb) {
        this.collectState(object, sb);
        sb.setPropertyIndex(0);
        sb.setState(TwoPhaseStateBuilderState.SECOND_RUN);
        this.collectState(other, sb);
    }

    protected abstract void collectState(@NonNull A var1, @NonNull StateCollector var2);

    public ToStringStyle getToStringStyle() {
        return this.toStringStyle;
    }

    public static interface StateCollector {
        public StateCollector add(Object var1);

        public StateCollector add(int var1);

        public StateCollector add(long var1);

        public StateCollector add(boolean var1);
    }
}

