/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.tuple;

import net.sf.staccatocommons.defs.function.Function;
import net.sf.staccatocommons.defs.function.Function2;
import net.sf.staccatocommons.defs.function.Function3;
import net.sf.staccatocommons.defs.predicate.Predicate;
import net.sf.staccatocommons.defs.predicate.Predicate2;
import net.sf.staccatocommons.lang.function.AbstractFunction;
import net.sf.staccatocommons.lang.function.AbstractFunction2;
import net.sf.staccatocommons.lang.function.AbstractFunction3;
import net.sf.staccatocommons.lang.predicate.AbstractPredicate;
import net.sf.staccatocommons.lang.predicate.AbstractPredicate2;
import net.sf.staccatocommons.lang.tuple.Pair;
import net.sf.staccatocommons.lang.tuple.Quadruple;
import net.sf.staccatocommons.lang.tuple.Triple;
import net.sf.staccatocommons.lang.tuple.Tuple;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class Tuples {
    private static final Function FIRST = Tuples.firstInitializer();
    private static final Function SECOND = Tuples.secondInitializer();
    private static final Function THIRD = Tuples.thirdInitializer();
    private static final Function FOURTH = Tuples.fourthInitializer();
    private static final Function3 TO_TRIPLE = Tuples.toTripleInitializer();
    private static final Function2 TO_PAIR = Tuples.toPairInitializer();

    @Constant
    public static <A> Function<Tuple.FirstAware<A>, A> first() {
        return FIRST;
    }

    @Constant
    public static <A> Function<Tuple.SecondAware<A>, A> second() {
        return SECOND;
    }

    @Constant
    public static <A> Function<Tuple.ThirdAware<A>, A> third() {
        return THIRD;
    }

    @Constant
    public static <A> Function<Tuple.FourthAware<A>, A> fourth() {
        return FOURTH;
    }

    @NonNull
    public static <T1, T2, T3, T4> Quadruple<T1, T2, T3, T4> _(T1 first, T2 second, T3 third, T4 fourth) {
        return new Quadruple<T1, T2, T3, T4>(first, second, third, fourth);
    }

    @NonNull
    public static <T1, T2, T3> Triple<T1, T2, T3> _(T1 first, T2 second, T3 third) {
        return new Triple<T1, T2, T3>(first, second, third);
    }

    @NonNull
    public static <T1, T2> Pair<T1, T2> _(T1 first, T2 second) {
        return new Pair<T1, T2>(first, second);
    }

    @Constant
    public static <T1, T2, T3> Function3<T1, T2, T3, Triple<T1, T2, T3>> toTriple() {
        return TO_TRIPLE;
    }

    @Constant
    public static <T1, T2> Function2<T1, T2, Pair<T1, T2>> toPair() {
        return TO_PAIR;
    }

    public static <A, B, C> Function2<A, B, C> curry(final Function<Pair<A, B>, C> function) {
        return new AbstractFunction2<A, B, C>(){

            public C apply(A arg0, B arg1) {
                return function.apply(Tuples._(arg0, arg1));
            }
        };
    }

    public static <A, B> Predicate2<A, B> curry(final Predicate<Pair<A, B>> predicate) {
        return new AbstractPredicate2<A, B>(){

            public boolean eval(A arg0, B arg1) {
                return predicate.eval(Tuples._(arg0, arg1));
            }
        };
    }

    public static <A, B, C> Function<Pair<A, B>, C> uncurry(final Function2<A, B, C> function) {
        return new AbstractFunction<Pair<A, B>, C>(){

            public C apply(Pair<A, B> argument) {
                return function.apply(argument.first(), argument.second());
            }
        };
    }

    public static <A, B> Predicate<Pair<A, B>> uncurry(final Predicate2<A, B> predicate) {
        return new AbstractPredicate<Pair<A, B>>(){

            @Override
            public boolean eval(Pair<A, B> argument) {
                return predicate.eval(argument.first(), argument.second());
            }
        };
    }

    private static Function firstInitializer() {
        return new AbstractFunction<Tuple.FirstAware<A>, A>(){

            public A apply(Tuple.FirstAware<A> arg) {
                return arg._0();
            }
        };
    }

    private static Function secondInitializer() {
        return new AbstractFunction<Tuple.SecondAware<A>, A>(){

            public A apply(Tuple.SecondAware<A> arg) {
                return arg._1();
            }
        };
    }

    private static Function thirdInitializer() {
        return new AbstractFunction<Tuple.ThirdAware<A>, A>(){

            public A apply(Tuple.ThirdAware<A> arg) {
                return arg._2();
            }
        };
    }

    private static Function fourthInitializer() {
        return new AbstractFunction<Tuple.FourthAware<A>, A>(){

            public A apply(Tuple.FourthAware<A> arg) {
                return arg._3();
            }
        };
    }

    private static Function3 toTripleInitializer() {
        return new AbstractFunction3<T1, T2, T3, Triple<T1, T2, T3>>(){

            public Triple<T1, T2, T3> apply(T1 arg0, T2 arg1, T3 arg2) {
                return Tuples._(arg0, arg1, arg2);
            }
        };
    }

    private static Function2 toPairInitializer() {
        return new AbstractFunction2<T1, T2, Pair<T1, T2>>(){

            public Pair<T1, T2> apply(T1 arg0, T2 arg1) {
                return Tuples._(arg0, arg1);
            }
        };
    }
}

